CONNECT  SYS/MANAGER  AS SYSDBA;

CREATE OR REPLACE DIRECTORY dat_dir AS 'C:\Oradata\Data';
CREATE OR REPLACE DIRECTORY log_dir AS 'C:\Oradata\Log';
CREATE OR REPLACE DIRECTORY bad_dir AS 'C:\Oradata\Bad';

GRANT READ ON DIRECTORY dat_dir TO scott;
GRANT WRITE ON DIRECTORY log_dir TO scott;
GRANT WRITE ON DIRECTORY bad_dir TO scott;

DISCONNECT;
CONNECT scott/tiger;

DROP TABLE revext;
CREATE TABLE revext (person      VARCHAR2(20),
                     rev_jan     NUMBER(4),
                     rev_feb     NUMBER(4),
                     rev_mar     NUMBER(4),
                     rev_apr     NUMBER(4),
                     rev_mai     NUMBER(4),
                     rev_jun     NUMBER(4),
                     rev_jul     NUMBER(4),
                     rev_aug     NUMBER(4),
                     rev_sep     NUMBER(4),
                     rev_oct     NUMBER(4),
                     rev_nov     NUMBER(4),
                     rev_dez     NUMBER(4))
 ORGANIZATION EXTERNAL
 (
   TYPE ORACLE_LOADER
   DEFAULT DIRECTORY dat_dir
   ACCESS PARAMETERS
   (
     records delimited by newline
     badfile bad_dir:'revext%a_%p.bad'
     logfile log_dir:'revext%a_%p.log'
     fields terminated by ','
     missing field values are null
     ( person,
       rev_jan,
       rev_feb,
       rev_mar,
       rev_apr,
       rev_mai,
       rev_jun,
       rev_jul,
       rev_aug,
       rev_sep,
       rev_oct,
       rev_nov,
       rev_dez
     )
   )
   LOCATION ('revext.dat')
 )
 PARALLEL 4
 REJECT LIMIT UNLIMITED;

 CREATE TABLE revenue (
    person       VARCHAR2(20),
    month        VARCHAR2(3),
    revenue      NUMBER,
    CONSTRAINT revenue_pk PRIMARY KEY (person,month));

INSERT INTO revenue (person,month,revenue)
   SELECT person,'Jan',rev_jan
   FROM revext
   WHERE rev_jan IS NOT NULL
UNION ALL
   SELECT person,'Feb',rev_feb
   FROM revext
   WHERE rev_feb IS NOT NULL
UNION ALL
   SELECT person,'Mar',rev_mar
   FROM revext
   WHERE rev_mar IS NOT NULL
UNION ALL
   SELECT person,'Apr',rev_apr
   FROM revext
   WHERE rev_apr IS NOT NULL
UNION ALL
   SELECT person,'Mai',rev_mai
   FROM revext
   WHERE rev_mai IS NOT NULL
UNION ALL
   SELECT person,'Jun',rev_jun
   FROM revext
   WHERE rev_jun IS NOT NULL
UNION ALL
   SELECT person,'Jul',rev_jul
   FROM revext
   WHERE rev_jul IS NOT NULL
UNION ALL
   SELECT person,'Aug',rev_aug
   FROM revext
   WHERE rev_aug IS NOT NULL
UNION ALL
   SELECT person,'Sep',rev_sep
   FROM revext
   WHERE rev_sep IS NOT NULL
UNION ALL
   SELECT person,'Oct',rev_oct
   FROM revext
   WHERE rev_oct IS NOT NULL
UNION ALL
   SELECT person,'Nov',rev_nov
   FROM revext
   WHERE rev_nov IS NOT NULL
UNION ALL
   SELECT person,'Dez',rev_dez
   FROM revext
   WHERE rev_dez IS NOT NULL;
ROLLBACK;

DROP TYPE revenue_row;
CREATE TYPE revenue_row AS OBJECT (
   person     VARCHAR2(20),
   month      VARCHAR2(3),
   revenue    NUMBER
);
/

DROP TYPE revenue_tab;
CREATE TYPE revenue_tab
   AS TABLE OF revenue_row;
/

DROP PACKAGE revenue_pkg;
CREATE OR REPLACE PACKAGE revenue_pkg
AS
   TYPE revenue_cur IS REF CURSOR RETURN revext%ROWTYPE;
   FUNCTION revenue_fun (revenue_arg IN revenue_cur)
      RETURN revenue_tab
      PARALLEL_ENABLE (PARTITION revenue_arg BY ANY)
      PIPELINED;
END;
/

CREATE OR REPLACE PACKAGE BODY revenue_pkg AS
   FUNCTION revenue_fun (revenue_arg IN revenue_cur)
   RETURN revenue_tab
   PARALLEL_ENABLE (PARTITION revenue_arg BY ANY)
   PIPELINED IS revenue_rec revext%ROWTYPE;
      outrow_jan revenue_row := revenue_row('','',0);
      outrow_feb revenue_row := revenue_row('','',0);
      outrow_mar revenue_row := revenue_row('','',0);
      outrow_apr revenue_row := revenue_row('','',0);
      outrow_mai revenue_row := revenue_row('','',0);
      outrow_jun revenue_row := revenue_row('','',0);
      outrow_jul revenue_row := revenue_row('','',0);
      outrow_aug revenue_row := revenue_row('','',0);
      outrow_sep revenue_row := revenue_row('','',0);
      outrow_oct revenue_row := revenue_row('','',0);
      outrow_nov revenue_row := revenue_row('','',0);
      outrow_dez revenue_row := revenue_row('','',0);
   BEGIN
      LOOP
         FETCH revenue_arg INTO revenue_rec;
         EXIT WHEN revenue_arg%NOTFOUND;

         IF revenue_rec.rev_jan IS NOT NULL THEN
           outrow_jan.person := revenue_rec.person;
           outrow_jan.month := 'Jan';
           outrow_jan.revenue := revenue_rec.rev_jan;
           PIPE ROW (outrow_jan);
         END IF;

         IF revenue_rec.rev_feb IS NOT NULL THEN
           outrow_feb.person := revenue_rec.person;
           outrow_feb.month := 'Feb';
           outrow_feb.revenue := revenue_rec.rev_feb;
           PIPE ROW (outrow_feb);
         END IF;

         IF revenue_rec.rev_mar IS NOT NULL THEN
           outrow_mar.person := revenue_rec.person;
           outrow_mar.month := 'Mar';
           outrow_mar.revenue := revenue_rec.rev_mar;
           PIPE ROW (outrow_mar);
         END IF;

         IF revenue_rec.rev_apr IS NOT NULL THEN
           outrow_apr.person := revenue_rec.person;
           outrow_apr.month := 'Apr';
           outrow_apr.revenue := revenue_rec.rev_apr;
           PIPE ROW (outrow_apr);
         END IF;

         IF revenue_rec.rev_mai IS NOT NULL THEN
           outrow_mai.person := revenue_rec.person;
           outrow_mai.month := 'Mai';
           outrow_mai.revenue := revenue_rec.rev_mai;
           PIPE ROW (outrow_mai);
         END IF;

         IF revenue_rec.rev_jun IS NOT NULL THEN
           outrow_jun.person := revenue_rec.person;
           outrow_jun.month := 'Jun';
           outrow_jun.revenue := revenue_rec.rev_jun;
           PIPE ROW (outrow_jun);
         END IF;

         IF revenue_rec.rev_jul IS NOT NULL THEN
           outrow_jul.person := revenue_rec.person;
           outrow_jul.month := 'Jul';
           outrow_jul.revenue := revenue_rec.rev_jul;
           PIPE ROW (outrow_jul);
         END IF;

         IF revenue_rec.rev_aug IS NOT NULL THEN
           outrow_aug.person := revenue_rec.person;
           outrow_aug.month := 'Aug';
           outrow_aug.revenue := revenue_rec.rev_aug;
           PIPE ROW (outrow_aug);
         END IF;

         IF revenue_rec.rev_sep IS NOT NULL THEN
           outrow_sep.person := revenue_rec.person;
           outrow_sep.month := 'Sep';
           outrow_sep.revenue := revenue_rec.rev_sep;
           PIPE ROW (outrow_sep);
         END IF;

         IF revenue_rec.rev_oct IS NOT NULL THEN
           outrow_oct.person := revenue_rec.person;
           outrow_oct.month := 'Oct';
           outrow_oct.revenue := revenue_rec.rev_oct;
           PIPE ROW (outrow_oct);
         END IF;

         IF revenue_rec.rev_nov IS NOT NULL THEN
           outrow_nov.person := revenue_rec.person;
           outrow_nov.month := 'Nov';
           outrow_nov.revenue := revenue_rec.rev_nov;
           PIPE ROW (outrow_nov);
         END IF;

         IF revenue_rec.rev_dez IS NOT NULL THEN
           outrow_dez.person := revenue_rec.person;
           outrow_dez.month := 'Dez';
           outrow_dez.revenue := revenue_rec.rev_dez;
           PIPE ROW (outrow_dez);
         END IF;

      END LOOP;
      RETURN;
   END;
END;
/

ALTER SESSION ENABLE PARALLEL DML;

INSERT /*+ APPEND PARALLEL (t,4) */ INTO revenue t
   SELECT *
   FROM TABLE (revenue_pkg.revenue_fun (
        CURSOR(SELECT person,
                      rev_jan,
                      rev_feb,
                      rev_mar,
                      rev_apr,
                      rev_mai,
                      rev_jun,
                      rev_jul,
                      rev_aug,
                      rev_sep,
                      rev_oct,
                      rev_nov,
                      rev_dez
               FROM revext)));
COMMIT;

DECLARE
BEGIN
   FOR inrec IN (
      SELECT person,rev_jan,rev_feb,rev_mar,rev_apr,rev_mai,rev_jun,
                    rev_jul,rev_aug,rev_sep,rev_oct,rev_nov,rev_dez
      FROM revext
   ) LOOP
      /* Jan Data */
      IF inrec.rev_jan IS NOT NULL THEN
         UPDATE revenue
         SET revenue = inrec.rev_jan
         WHERE person = inrec.person
         AND month = 'Jan';
         IF SQL%ROWCOUNT = 0 THEN
            INSERT INTO revenue
               (person, month, revenue)
               VALUES (inrec.person, 'Jan', inrec.rev_jan);
         END IF;
      END IF;
      /* Feb Data */
      IF inrec.rev_feb IS NOT NULL THEN
         UPDATE revenue
         SET revenue = inrec.rev_feb
         WHERE person = inrec.person
         AND month = 'Feb';
         IF SQL%ROWCOUNT = 0 THEN
            INSERT INTO revenue
               (person, month, revenue)
               VALUES (inrec.person, 'Feb', inrec.rev_feb);
         END IF;
      END IF;
      /* Mar Data */
      IF inrec.rev_mar IS NOT NULL THEN
         UPDATE revenue
         SET revenue = inrec.rev_mar
         WHERE person = inrec.person
         AND month = 'Mar';
         IF SQL%ROWCOUNT = 0 THEN
            INSERT INTO revenue
               (person, month, revenue)
               VALUES (inrec.person, 'Mar', inrec.rev_mar);
         END IF;
      END IF;
      /* Apr Data */
      IF inrec.rev_apr IS NOT NULL THEN
         UPDATE revenue
         SET revenue = inrec.rev_apr
         WHERE person = inrec.person
         AND month = 'Apr';
         IF SQL%ROWCOUNT = 0 THEN
            INSERT INTO revenue
               (person, month, revenue)
               VALUES (inrec.person, 'Apr', inrec.rev_apr);
         END IF;
      END IF;
      /* Mai Data */
      IF inrec.rev_mai IS NOT NULL THEN
         UPDATE revenue
         SET revenue = inrec.rev_mai
         WHERE person = inrec.person
         AND month = 'Mai';
         IF SQL%ROWCOUNT = 0 THEN
            INSERT INTO revenue
               (person, month, revenue)
               VALUES (inrec.person, 'Mai', inrec.rev_mai);
         END IF;
      END IF;
      /* Jun Data */
      IF inrec.rev_jun IS NOT NULL THEN
         UPDATE revenue
         SET revenue = inrec.rev_jun
         WHERE person = inrec.person
         AND month = 'Jun';
         IF SQL%ROWCOUNT = 0 THEN
            INSERT INTO revenue
               (person, month, revenue)
               VALUES (inrec.person, 'Jun', inrec.rev_jun);
         END IF;
      END IF;
      /* Jul Data */
      IF inrec.rev_jul IS NOT NULL THEN
         UPDATE revenue
         SET revenue = inrec.rev_jul
         WHERE person = inrec.person
         AND month = 'Jul';
         IF SQL%ROWCOUNT = 0 THEN
            INSERT INTO revenue
               (person, month, revenue)
               VALUES (inrec.person, 'Jul', inrec.rev_jul);
         END IF;
      END IF;
      /* Aug Data */
      IF inrec.rev_aug IS NOT NULL THEN
         UPDATE revenue
         SET revenue = inrec.rev_aug
         WHERE person = inrec.person
         AND month = 'aug';
         IF SQL%ROWCOUNT = 0 THEN
            INSERT INTO revenue
               (person, month, revenue)
               VALUES (inrec.person, 'Aug', inrec.rev_aug);
         END IF;
      END IF;
      /* Sep Data */
      IF inrec.rev_sep IS NOT NULL THEN
         UPDATE revenue
         SET revenue = inrec.rev_sep
         WHERE person = inrec.person
         AND month = 'Sep';
         IF SQL%ROWCOUNT = 0 THEN
            INSERT INTO revenue
               (person, month, revenue)
               VALUES (inrec.person, 'Sep', inrec.rev_sep);
         END IF;
      END IF;
      /* Oct Data */
      IF inrec.rev_oct IS NOT NULL THEN
         UPDATE revenue
         SET revenue = inrec.rev_oct
         WHERE person = inrec.person
         AND month = 'Oct';
         IF SQL%ROWCOUNT = 0 THEN
            INSERT INTO revenue
               (person, month, revenue)
               VALUES (inrec.person, 'Oct', inrec.rev_oct);
         END IF;
      END IF;
      /* Nov Data */
      IF inrec.rev_nov IS NOT NULL THEN
         UPDATE revenue
         SET revenue = inrec.rev_nov
         WHERE person = inrec.person
         AND month = 'Nov';
         IF SQL%ROWCOUNT = 0 THEN
            INSERT INTO revenue
               (person, month, revenue)
               VALUES (inrec.person, 'Nov', inrec.rev_nov);
         END IF;
      END IF;
      /* Dez Data */
      IF inrec.rev_dez IS NOT NULL THEN
         UPDATE revenue
         SET revenue = inrec.rev_dez
         WHERE person = inrec.person
         AND month = 'Dez';
         IF SQL%ROWCOUNT = 0 THEN
            INSERT INTO revenue
               (person, month, revenue)
               VALUES (inrec.person, 'Dez', inrec.rev_dez);
         END IF;
      END IF;
   END LOOP;
END;
/

   FROM TABLE (revenue_pkg.revenue_fun (
        CURSOR(SELECT person,
                      rev_jan,
                      rev_feb,
                      rev_mar,
                      rev_apr,
                      rev_mai,
                      rev_jun,
                      rev_jul,
                      rev_aug,
                      rev_sep,
                      rev_oct,
                      rev_nov,
                      rev_dez
               FROM revext)));


DROP TYPE revenue_row;
CREATE TYPE revenue_row AS OBJECT (
   person     VARCHAR2(20),
   month      VARCHAR2(3),
   revenue    NUMBER
);
/

MERGE INTO revenue dest
USING (SELECT * FROM TABLE (revenue_pkg.revenue_fun(
        CURSOR(SELECT person,
                      rev_jan,
                      rev_feb,
                      rev_mar,
                      rev_apr,
                      rev_mai,
                      rev_jun,
                      rev_jul,
                      rev_aug,
                      rev_sep,
                      rev_oct,
                      rev_nov,
                      rev_dez
               FROM revext)))) src
ON (dest.person = src.person
AND dest.month = src.month)
WHEN MATCHED THEN
  UPDATE SET dest.revenue = src.revenue
WHEN NOT MATCHED THEN
  INSERT (person, month, revenue)
  VALUES (src.person, src.month, src.revenue);

COMMIT;
