clear

@del /q bin\*

@REM Create DLL modules 'Hello', 'HowDoYouDo' and 'GoodBye' into sub-folder bin
@REM (/nologo supresses compiler info banner)
@REM
csc /nologo /debug /t:module /out:bin\Hello.dll Hello.cs
csc /nologo /debug /t:module /out:bin\GoodBye.dll GoodBye.cs
csc /nologo /debug /t:module /out:bin\HowDoYouDo.dll HowDoYouDo.cs

@REM Create a private assembly DLL 'GreetAssembly' from 'Hello' and 'GoodBye' into sub-folder bin
@REM
al /nologo /t:library /out:bin\GreetAssembly.dll bin\Hello.dll bin\GoodBye.dll
sn -k app.snk

@REM Same with CSC
@REM csc /nologo /debug /t:library /lib:bin /addmodule:Hello.dll;GoodBye.dll /out:bin\GreetAssembly.dll

@REM Create a shared assembly DLL 'HowDoYouDoSharedAssembly' into sub-folder bin
@REM
al /nologo /t:library /out:bin\HowDoYouDoSharedAssembly.dll bin\HowDoYouDo.dll

@REM Same without attributes in source file
@REM al /nologo /t:library /keyfile:app.snk /v:1.0.0.0 /out:bin\HowDoYouDoSharedAssembly.dll bin\HowDoYouDo.dll

@REM Load shared assembly DLL 'HowDoYouDoSharedAssembly' into GAC
@REM
gacutil /nologo /i bin\HowDoYouDoSharedAssembly.dll

@REM Main program 'app1' with reference to assembly in sub-folder bin
@REM
csc /nologo /debug /t:exe /r:bin\GreetAssembly.dll;bin\HowDoYouDoSharedAssembly.dll /out:bin\App1.exe App.cs

@REM Main program 'app2' using DLLs directly in sub-folder bin
@REM
csc /nologo /debug /t:exe /lib:bin /addmodule:Hello.dll;GoodBye.dll /r:bin\HowDoYouDoSharedAssembly.dll /out:bin\App2.exe App.cs

@REM Delete local shared assembly, it is available in GAC
@REM
@del bin\HowDoYouDoSharedAssembly.*

@ECHO ------
@ECHO Programs located in sub-folder bin:
@ECHO   app1 - with reference to private assembly
@ECHO   app2 - using DLLs directly
@ECHO ------

