/*
* @author  Umesh
* @version 1.0
*
* Development Environment         : JDeveloper 2.0
*
* Name of the Application         : BFILEFrame.java
*
* Creation/ Modification History  :
*
*    Umesh       11-Jan-1999      Creation
*    Sujatha     14-May-2002      Re-certified on Oracle9i JDeveloper
*
*/
package oracle.otnsamples.jdbc.bfile;

import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.MediaTracker;
import java.awt.GridBagConstraints;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;

// Package for handling IOStreams
import java.io.InputStream;
import java.io.IOException;
import java.io.FileOutputStream;

// Swing 1.1 imports
import javax.swing.JOptionPane;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.JLabel;
import javax.swing.JButton;
import javax.swing.JTextArea;

/**
 *  This class handles the GUI for the BFILESample application.
 */

public class BFILEFrame extends JFrame {

  /**  The Main Application Class which uses this frame */
  BFILESample parent;   

  /** Labels used in the UI */
  JLabel bfileImageLabel = new JLabel();

  /** Displays error and status messages */
  JTextField statusField = new JTextField();

  /** Button for specifying "EXIT" operation */  
  JButton exitButton = new JButton();

  /** Button for specifying "SELECT" operation */  
  JButton selectButton = new JButton();

  /**  Object for handling and displaying image - Image Object */
  Image image = null;  

  /**  Object for handling and displaying image - Media Tracker */  
  MediaTracker tracker = null; 

  /** Panel to Show Image Read from BFILE_TABLE */
  Panel panel = new Panel(); // 

  /**  Layout Manager */
  GridBagLayout gridBagLayout = new GridBagLayout();

  /**
   *  Constructor. Initializes GUI components and sets up the Listeners
   */
  public BFILEFrame(BFILESample newParent){
    try {
      parent = newParent;
      jbInit();  // Initialize all the GUI Components
      setupListeners(); // Setting up actionlisteners for GUI components
    } catch (Exception e) {
      putStatus(" Error while initializing ..." + e.toString());
    }
  }

  /**
   * Method to Prompt the user for Full Directory Path, where he/she has copied
   * the image file (architect.gif).
   * After user enters the Full Directory Path of the image file, it is returned
   * back to the main application as a String.
   */
  public String getDirectoryPath() {
    // Setup the JOptionPane for accepting Full Directory Path

    JTextArea dirTextArea = new JTextArea(1,30);
    dirTextArea.setText("/private/otn/image");// Setting Default Initial Value of dirPath
    Object[] objects = new Object[2];
    objects[0] = "Enter Full Directory Path of image file on Database Server";
    objects[1] = dirTextArea;
    String[] options = {"Proceed","Cancel & Exit"};
    
    // If user has entered directory path and presses Proceed then return
    // directory path else return 'Cancel' String
    if (JOptionPane.showOptionDialog(
        this, objects,"Enter Full Directory Path", JOptionPane.DEFAULT_OPTION,
        JOptionPane.QUESTION_MESSAGE, null, options, options[0]) == 0)
          return dirTextArea.getText();
    else
       return "Cancel";
  }

  /**
   * Method to Display the image fetched from the BFILE Column.
   * Note that the parameter passed is Binary Input Stream
   */
  public void displayFile(InputStream instream) {
    try {
      // Clearing Contents on the image Panel
      Graphics graphics = panel.getGraphics();
      Rectangle rect = panel.getBounds();
      graphics.clearRect(80,50,rect.getSize().width,rect.getSize().height);

      // Open File Output Stream to store the Fetched image file locally as bfile.gif
      FileOutputStream file = new FileOutputStream("bfile.gif");

      // Read the Binary File in chunks of 10 bytes
      int    chunkSize = 10;
      long   lengthRead;
      byte[] buffer = new byte[chunkSize];

      while ((lengthRead = instream.read(buffer)) != -1) {
        file.write(buffer);
        file.flush();
      }
      instream.close(); // Close the input Stream
      file.close(); // Close the File Output Stream

      // Display the image Stored in the file bfile.gif
      tracker = new MediaTracker(this); //

      // Get the Fetched Image from bfile.gif
      image = Toolkit.getDefaultToolkit().getImage("bfile.gif");
      tracker.addImage(image,0);
      tracker.waitForID(0);
      graphics = panel.getGraphics(); // Get the Graphics Object
      graphics.drawImage(image,80,50,this); // Draw Image

      appendStatus("Image from BFILE displayed");
    } catch (IOException ex) { // Trap IO Errors
         putStatus(" IOErrors while displaying Image File " + ex.toString());
    }
      catch (InterruptedException ex) { // Trap Interrupted Errors
         putStatus(" Stream Interruption Errors while displaying Image File\n "
                     + ex.toString());
    }
  }

  /**
  *  Sets up the listeners that respond to user actions, like button
  *  press.
  */
  public void setupListeners() {
    // Setup the exit button listener
    exitButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        // Pass the Event to Parent Class for handling
        parent.dispatchEvent("EXIT");
      }
     });

    // Setup the Select button listener
    selectButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        // Pass the Event to Parent Class for handling
        parent.dispatchEvent("SELECT");
      }
    });

    // The window exit listener
    this.addWindowListener(new java.awt.event.WindowAdapter() {
      public void windowClosing(WindowEvent e) {
        parent.dispatchEvent("EXIT");
      }
    });
  }

  /**
   * Clears status field
   */
  public void clearStatus( ) {         
    statusField.setText("");
  }

  /**
   * Displays status on status field
   */  
  public void putStatus( String status ) { 
    statusField.setText(status);
    statusField.setScrollOffset(0);
  }

  /**
   * Appends status to status field
   */    
  public void appendStatus(String status) { 
    statusField.setText(statusField.getText() + "\n" + status);
    statusField.setScrollOffset(0);
  }

  /**
   * Initialize all the GUI components and the layout
   */
  public void jbInit() throws Exception {
    this.getContentPane().setLayout(gridBagLayout);
    panel.setBackground(Color.black);
    exitButton.setText("EXIT");
    selectButton.setText("SELECT");
    statusField.setFont(new Font("Monospaced",0,12));
    statusField.setBackground(Color.lightGray);
    statusField.setDisabledTextColor(Color.lightGray);
    statusField.setEditable(false);
    bfileImageLabel.setText("BFILE Image");
    this.getContentPane().add(panel,
         new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, GridBagConstraints.SOUTH,
         GridBagConstraints.NONE,  new Insets(0, 12, 3, 9), 404, 195));
    this.getContentPane().add(exitButton,
         new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0 ,GridBagConstraints.SOUTHEAST,
         GridBagConstraints.NONE, new Insets(32, 14, 11, 4), 45, 9));
    this.getContentPane().add(selectButton,
         new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0,GridBagConstraints.SOUTHEAST,
         GridBagConstraints.NONE, new Insets(21, 212, 11, 3), 61, 8));
    this.getContentPane().add(statusField,
         new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0 ,GridBagConstraints.WEST,
         GridBagConstraints.NONE, new Insets(3, 2, 3, 2), 633, 20));
    this.getContentPane().add(bfileImageLabel,
         new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0,GridBagConstraints.SOUTHWEST,
         GridBagConstraints.NONE, new Insets(20, 18, 5, 0), 169, 10));
    this.setTitle("Illustrating BFILES Using JDBC");
    this.setSize(new Dimension(577, 394));
  }
}






