/*
 * @author  Reghu
 * @version 1.0
 *
 * Development Environment        :  JDeveloper 2.0
 * Name of the Application        :  ColumnTypeFrame.java
 * Creation/Modification History  :
 *
 *   Reghu       14-Jan-1999     Created
 *   Sujatha     14-May-2002     Re-certified on Oracle9i JDeveloper 
 *
 */
package oracle.otnsamples.jdbc.columntype;

import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Dimension;
import java.awt.Insets;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;

// SWING version 1.1 imports 
import javax.swing.Timer;
import javax.swing.JLabel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import javax.swing.JTextField;

/**
 * This class handles the GUI for the ColumnTypeSample application.
 */
public class ColumnTypeFrame extends JFrame implements Runnable{

  /** The main application class which uses this frame */
  ColumnTypeSample parent;

  /** Thread Object */
  Thread colTypeThread = null; 

  /** Button for specifying "NORMAL" operation */  
  JButton  normal;
  
  /** Button for specifying "FETCH" operation */    
  JButton  fetch;

  /** Button for specifying "EXIT" operation */    
  JButton  exit;

   /** Textfields for displaying the output and status */
   JTextField normalTime;
   JTextField fetchTime;
   JTextField statusField;
   
   /** Label for displaying the output */   
   JLabel timeLabel;

   /** To illustrate the progress of current fetch */
   JProgressBar progressbar;
   Timer timer;

   boolean flag = false;

   /** Layout manager object */
   GridBagLayout gridBagLayout = new GridBagLayout();

  /**
   * Constructor, initializes and sets up listeners for the GUI components of
   * the application
   */
  public ColumnTypeFrame(ColumnTypeSample newParent) {
    try {
      parent = newParent;
      jbInit();          // Other GUI components initializations
      setupListeners();  // Sets up the event listeners and actions
    } catch( Exception ex ) {
      putStatus("Error..!!" +'\n'+ex.toString());
    }
  }

  /**
   *  Method to display the results in the text field based on the flag value
   */
  public void displayResult(boolean statusFlag, Integer timetaken) {
    if( statusFlag )
      fetchTime.setText( timetaken.toString() );
    else
      normalTime.setText( timetaken.toString() );
  }

  /**
   * Start the colTypeThread thread to select records from the table
   */
  public void colTypeThreadStart(boolean set){
    flag = set;
    if( colTypeThread == null ) {
      colTypeThread = new Thread(this,"ColumnType");
      colTypeThread.start();
    }
  }

  /**
   * This method is called by colTypeThread Thread class.@see java.lang.Thread
   * Here the run() method is implemented to call dispatchEvent() method of
   * ColumnTypeSample class.
   */
  public void run() {
     buttonStateChange(false);
     // Dispatch event
     parent.dispatchEvent("START SELECT");
     buttonStateChange(true);
     colTypeThread = null;
  }

  /**
   * This method changes the Button state based on the value of p_state
   */
  public void buttonStateChange( boolean state ) {
     normal.setEnabled( state );
     fetch.setEnabled( state );
  }

  /**
   * TimerListener class is implemented as an inner class. The actionPerformed()
   * method in this TimerListener class is called each time the Timer "goes off".
   */
  class TimerListener implements ActionListener {
    public void actionPerformed( ActionEvent evt ) {
      progressbar.setMaximum( parent.numTotalRows );
      
      // Sets the current value of fetchedRows to the progressbar
      progressbar.setValue(parent.numFetchedRows);
      if( parent.numFetchedRows == parent.numTotalRows){
        timer.stop();
        progressbar.setValue(progressbar.getMinimum());
      }
    }
  }

  /**
   * Sets up the listeners that respond to user actions like button press and
   * performing corresponding actions
   */
  public void setupListeners() {

   //Setup the "NORMAL FETCH" button Listener
   normal.addActionListener(new java.awt.event.ActionListener(){
     public void actionPerformed(ActionEvent evt){
       if( evt.getActionCommand() == "NORMAL" ) {
         normalTime.setText("");
         // Start a new thread to select records without column type specified
         colTypeThreadStart(false);
         // Start the Timer to initialize the Progressbar
         timer.start();
      }
     }
   });

    //Setup the "FETCH WITH COLUMN TYPE SPECIFIED" button Listener
    fetch.addActionListener(new java.awt.event.ActionListener(){
      public void actionPerformed( ActionEvent evt ){
        if(evt.getActionCommand() == "COLFETCH"){
          fetchTime.setText("");
          // Start a new thread to select records with column type specified
          colTypeThreadStart(true);
          // Start the Timer to initialize the Progressbar
          timer.start();
        }
      }
    });

    //Setup the "EXIT" button Listener
    exit.addActionListener(new java.awt.event.ActionListener(){
      public void actionPerformed( ActionEvent evt ) {
        if( evt.getActionCommand() =="EXIT" )
          parent.dispatchEvent("EXIT");
      }
    });
  }

  /**
   * Clears status field
   */
  public void clearStatus( ) {         
    statusField.setText("");
  }

  /**
   * Displays status on status field
   */  
  public void putStatus( String status ) { 
    statusField.setText(status);
    statusField.setScrollOffset(0);
  }

  /**
   * Appends status to status field
   */    
  public void appendStatus(String status) { 
    statusField.setText(statusField.getText() + "\n" + status);
    statusField.setScrollOffset(0);
  }


  /**
   * Initialize and setup the GUI components and Layout of the Application.
   */
  public void jbInit() throws Exception {
    normal = new JButton();
    fetch  = new JButton();
    exit   = new JButton();
    normalTime   = new JTextField();
    fetchTime    = new JTextField();
    statusField  = new JTextField();
    timeLabel = new JLabel();
    progressbar = new JProgressBar();
    timer = new Timer(200,new TimerListener());
    this.setTitle("Illustrating COLUMN TYPE SPECIFICATION Using JDBC");
    this.getContentPane().setLayout(gridBagLayout);
    this.setSize(new Dimension(542, 299));
    this.addWindowListener(new java.awt.event.WindowAdapter() {
      public void windowClosing(WindowEvent e) {
        parent.dispatchEvent("EXIT");
      }
    });
    normal.setText("DEFAULT  FETCH");
    normal.setActionCommand("NORMAL");
    normal.setFont(new Font("Dialog", 1, 16));
    normal.setToolTipText("Press to fetch records in Normal Mode");
    fetch.setFont(new Font("Dialog", 1, 16));
    fetch.setToolTipText("Press to fetch records with column type specified");
    fetch.setText("FETCH WITH COLUMN TYPE SPECIFIED");
    fetch.setActionCommand("COLFETCH");
    fetch.setRolloverEnabled(true);
    timeLabel.setText("Time Taken (ms)");
    timeLabel.setFont(new Font("Dialog", 1, 16));
    normalTime.setHorizontalAlignment(JTextField.CENTER);
    normalTime.setBackground(Color.gray);
    normalTime.setFont(new Font("Dialog", 1, 16));
    normalTime.setBorder(null);
    normalTime.setEditable(false);
    fetchTime.setHorizontalAlignment(JTextField.CENTER);
    fetchTime.setBackground(Color.gray);
    fetchTime.setFont(new Font("Dialog", 1, 16));
    fetchTime.setBorder(null);
    fetchTime.setEditable(false);
    exit.setText("EXIT");
    exit.setFont(new Font("Dialog", 1, 16));
    exit.setToolTipText("Press to Exit");
    progressbar.setToolTipText("Progress of Operation");
    progressbar.setMinimum(0);
    progressbar.setForeground(new Color(0, 0, 224));
    progressbar.setValue(0);
    progressbar.setBorderPainted(true);
    statusField.setBackground(Color.lightGray);
    statusField.setFont(new Font("Monospaced", 0, 16));
    statusField.setDisabledTextColor(Color.lightGray);
    statusField.setToolTipText("Status Bar");
    statusField.setEditable(false);
    normal.setEnabled(false);
    fetch.setEnabled(false);
    this.getContentPane().add(normal, new GridBagConstraints(0, 0, 1, 3, 0.0, 0.0
    ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(24, 7, 0, 0), 182, 17));
    this.getContentPane().add(fetch, new GridBagConstraints(0, 3, 1, 2, 0.0, 0.0
    ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(18, 6, 0, 0), 0, 20));
    this.getContentPane().add(timeLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
    ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 27, 0, 0), 7, 14));
    this.getContentPane().add(normalTime, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0
    ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(0, 15, 0, 2), 123, 8));
    this.getContentPane().add(fetchTime, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0
    ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(26, 15, 0, 2), 123, 7));
    this.getContentPane().add(exit, new GridBagConstraints(1, 5, 2, 2, 0.0, 0.0
    ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(14, 19, 0, 3), 53, 15));
    this.getContentPane().add(progressbar, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0
    ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(21, 6, 0, 0), 194, 12));
    this.getContentPane().add(statusField, new GridBagConstraints(0, 7, 3, 1, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(13, 9, 3, -1), 491, 39));
  }
}