/*
 * @author  Reghu
 * @version 1.0
 *
 * Development Environment        :  JDeveloper 2.0
 * Name of the Application        :  DMLFrame.java
 * Creation/Modification History  :
 *
 *    Reghu       27-Dec-1998      Created
 *    Sujatha     21-May-2002      Re-certified on Oracle9i JDeveloper  
 *
 */
package oracle.otnsamples.jdbc.dml;

import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Vector;

/* SWING version 1.1 imports */
import javax.swing.ListSelectionModel;
import javax.swing.JTextField;
import javax.swing.JLabel;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.JScrollPane;
import javax.swing.JFrame;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

/**
 * This class handles the GUI for the DMLSample application.
 */
public class DMLFrame extends JFrame {
   /** The main application class which uses this frame */
   DMLSample parent;

   /** Labels for textfields in the UI */
   JLabel codeLabel    = new JLabel();
   JLabel partnerLabel = new JLabel();
   JLabel nameLabel    = new JLabel();

   /** Textfields for displaying and entering database row values */
   JTextField codeTextfield    = new JTextField();
   JTextField nameTextfield    = new JTextField();
   JTextField partnerTextfield = new JTextField();

   /** Displays error and status messages */
   JTextField statusField = new JTextField();

   /** Buttons for specifying the DML operations to be performed */
   JButton insertButton = new JButton();
   JButton selectButton = new JButton();
   JButton modifyButton = new JButton();
   JButton delButton    = new JButton();
   JButton exitButton   = new JButton();
   JButton clearButton  = new JButton();

   /** The scroll pane holding jtable */
   JScrollPane jScrollPane1 = new JScrollPane();

   /** The JTable which displays the database rows*/
   JTable jtable;    
   
   /** Table Model for the JTable */
   GenTableModel tmodel;  

   /** Layout Manager object */
   GridBagLayout gridBagLayout = new GridBagLayout();

  /**
   *  Constructor, initializes and sets up listeners for the GUI components of
   *  the application
   */
  public DMLFrame( DMLSample newParent ) {
    try {
      parent = newParent;
      tableInit();       // JTable initializations
      jbInit();          // Other GUI components initializations
      setupListeners();  // Sets up the event listeners and actions
    } catch( Exception ex ) {
      statusField.setText("Error..!! " + '\n' + ex.toString());
    }
  }

  /**
   *  This method inserts a new row into the JTable
   */
  public void addToJTable(String code, String name, String partner) {
    Vector newrow = new Vector();

    // The column values are added to the Vector
    newrow.addElement(code);
    newrow.addElement(name);
    newrow.addElement(partner);

    // Add the row to the JTable
    tmodel.insertRow(newrow);
    jScrollPane1.repaint();

    // Clear the TextFields.
    clearfields();
  }

  /**
   *  This method updates an existing row in the JTable
   */
  public void updateJTable(String code, String name, String partner) {
    int selectedIndex = jtable.getSelectedRow(); //Get Row index
    Vector newrow = new Vector();

    // The column values are added to the Vector
    newrow.addElement(code);
    newrow.addElement(name);
    newrow.addElement(partner);

    // Update the row in the JTable
    tmodel.updateRow( newrow, selectedIndex );
    jScrollPane1.repaint();

    // Clear the TextFields.
    clearfields();
  }

  /**
   *  This method deletes the specified row from the JTable
   */
  public void deleteFromJTable() {
    int selectedIndex = jtable.getSelectedRow(); // Get Row index

    // Delete from JTable
    tmodel.deleteRow(selectedIndex);
    jScrollPane1.repaint();

    // Clear the TextFields.
    clearfields();
  }

  /**
   *  Populate the Textfields with values from the row selected in the JTable
   */
  public void printData(JTable table,int selectedRow) {
    //Get the values for the selected row
    TableModel model = table.getModel();
    String code    = (String) model.getValueAt(selectedRow,0);
    String name    = (String) model.getValueAt(selectedRow,1);
    String partner = (String) model.getValueAt(selectedRow,2);

    // Populate the Textfields with the values from the selected row
    codeTextfield.setText(code);
    nameTextfield.setText(name);
    partnerTextfield.setText(partner);

    statusField.setText("");
    insertButton.setEnabled(false);
  } 

  /**
   *  JTable initialization. Sets up the column name and the table model
   *  for the JTable
   */
  public void tableInit() {
    String[] cols = {"Airline Code", "Airline Name", "Partner"};
    Object[] defaultv = {"", "", ""};

    tmodel = new GenTableModel( cols, defaultv, 0);
    jtable = new JTable(tmodel);
  }

  /**
   *  Sets up the listeners that respond to user actions, including button press
   *  and row selection in the JTable
   */
  public void setupListeners() {
    // Set up the table row selection listener.Single row selection is allowed
    jtable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    jtable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){
      public void valueChanged( ListSelectionEvent e ) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if(!lsm.isSelectionEmpty()) {
          // Setup the action to be performed when a row selection event has
          // been captured. Calls printData to display the row values in the
          // Textfields
          int selectedRow = lsm.getMinSelectionIndex();
          printData(jtable, selectedRow);
        }
      }
    });
    
    // Setup the "INSERT" button listener.
    insertButton.addActionListener(new java.awt.event.ActionListener(){
      public void actionPerformed(ActionEvent evt){
        if( evt.getActionCommand() == "INSERT" ) {
          //Pass event to the parent class for handling
          parent.dispatchEvent("INSERT");
        }
      }
    });
    
    // Setup the "SELECT" button listener
    selectButton.addActionListener(new java.awt.event.ActionListener(){
      public void actionPerformed(ActionEvent evt){
        if( evt.getActionCommand() =="SELECT" ) {
          // Pass event to the parent class for handling
          parent.dispatchEvent("SELECT");
        }
      }
    });
    
    // Setup the "UPDATE" button listener
    modifyButton.addActionListener(new java.awt.event.ActionListener(){
      public void actionPerformed(ActionEvent evt) {
        if( evt.getActionCommand() =="UPDATE" ){
          // Pass event to the parent class for handling
          parent.dispatchEvent("UPDATE");
        }
      }
    });
    
    // Setup the "DELETE" button listener
    delButton.addActionListener(new java.awt.event.ActionListener(){
      public void actionPerformed(ActionEvent evt){
        if( evt.getActionCommand() =="DELETE" ) {
          // Pass event to the parent class for handling
          parent.dispatchEvent("DELETE");
        }
      }
    });
    
    // Setup the "CLEAR" button listener
    clearButton.addActionListener(new java.awt.event.ActionListener(){
      public void actionPerformed(ActionEvent evt){
        if(evt.getActionCommand() =="CLEAR") {
          // Setup the action to be performed when the clear button is
          // pressed. Calls the clearfields() method which clear the textfields
          clearfields();
          insertButton.setEnabled(true);
        }
      }
    });
    
    // Setup the "EXIT" button listener
    exitButton.addActionListener(new java.awt.event.ActionListener(){
      public void actionPerformed(ActionEvent evt) {
        if(evt.getActionCommand() =="EXIT")
          // Pass event to the parent class for handling
          parent.dispatchEvent("EXIT");
      }
    });
  }

  /**
   *  Clear the Textfields
   */
  public void clearfields() {
    codeTextfield.setText("");
    nameTextfield.setText("");
    partnerTextfield.setText("");
  }

  /**
   * Clears status field
   */
  public void clearStatus( ) {         
    statusField.setText("");
  }

  /**
   * Displays status on status field
   */  
  public void putStatus( String status ) { 
    statusField.setText(status);
    statusField.setScrollOffset(0);
  }

  /**
   * Appends status to status field
   */    
  public void appendStatus(String status) { 
    statusField.setText(statusField.getText() + "\n" + status);
    statusField.setScrollOffset(0);
  }


  /**
   *  Initialize all the GUI components and the layout
   */
  public void jbInit() throws Exception {
    this.getContentPane().setLayout(gridBagLayout);
    this.setSize(new Dimension(856, 629));
    this.addWindowListener(new java.awt.event.WindowAdapter() {
      public void windowClosing(WindowEvent e) {
        parent.dispatchEvent("EXIT");
      }
    });
    this.setTitle("Illustrating SQL DML Using JDBC");
    jtable.setRowHeight(20);
    jtable.setToolTipText("Table displays the rows");
    clearButton.setMaximumSize(new Dimension(97, 29));
    clearButton.setText("CLEAR");
    clearButton.setPreferredSize(new Dimension(97, 29));
    clearButton.setFont(new Font("Dialog", 1, 16));
    clearButton.setToolTipText("Press to clear the text fields");
    clearButton.setMinimumSize(new Dimension(97, 29));
    statusField.setFont(new Font("Dialog", 0, 14));
    statusField.setToolTipText("Status bar");
    statusField.setEditable(false);
    statusField.setBackground(Color.lightGray);
    codeLabel.setText("Code");
    codeLabel.setFont(new Font("Dialog", 1, 14));
    nameLabel.setText("Name");
    nameLabel.setFont(new Font("Dialog", 1, 14));
    codeTextfield.setToolTipText("Enter the Airlines Code");
    nameTextfield.setToolTipText("Enter the Airlines Name");
    partnerTextfield.setToolTipText("Enter the Airlines Partner");
    partnerLabel.setText("Partner");
    partnerLabel.setFont(new Font("Dialog", 1, 14));
    insertButton.setMaximumSize(new Dimension(97, 29));
    insertButton.setText("INSERT");
    insertButton.setPreferredSize(new Dimension(97, 29));
    insertButton.setFont(new Font("Dialog", 1, 16));
    insertButton.setToolTipText("Press to insert the record");
    insertButton.setMinimumSize(new Dimension(97, 29));
    selectButton.setText("SELECT");
    selectButton.setFont(new Font("Dialog", 1, 16));
    selectButton.setToolTipText("Press to select records");
    modifyButton.setMaximumSize(new Dimension(97, 29));
    modifyButton.setText("UPDATE");
    modifyButton.setPreferredSize(new Dimension(97, 29));
    modifyButton.setFont(new Font("Dialog", 1, 16));
    modifyButton.setToolTipText("Press to update the record");
    modifyButton.setMinimumSize(new Dimension(97, 29));
    delButton.setText("DELETE");
    delButton.setFont(new Font("Dialog", 1, 16));
    delButton.setToolTipText("Press to delete the record");
    exitButton.setMaximumSize(new Dimension(97, 29));
    exitButton.setText("EXIT");
    exitButton.setPreferredSize(new Dimension(97, 29));
    exitButton.setFont(new Font("Dialog", 1, 16));
    exitButton.setToolTipText("Press to exit the application");
    exitButton.setMinimumSize(new Dimension(97, 29));
    this.getContentPane().add(jScrollPane1, new GridBagConstraints(0, 0, 12, 1, 1.0, 1.0
     ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(19, 2, 0, 0), 291, -67));
    jScrollPane1.getViewport().add(jtable, null);
    this.getContentPane().add(codeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
     ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(20, 2, 0, 0), 4, 19));
    this.getContentPane().add(codeTextfield, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0
     ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(25, 0, 0, 0), 143, 11));
    this.getContentPane().add(nameLabel, new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0
     ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(24, 9, 0, 0), 14, 14));
    this.getContentPane().add(nameTextfield, new GridBagConstraints(4, 1, 4, 1, 1.0, 0.0
     ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(25, 0, 0, 0), 309, 10));
    this.getContentPane().add(partnerLabel, new GridBagConstraints(8, 1, 1, 1, 0.0, 0.0
     ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(25, 27, 0, 0), 4, 14));
    this.getContentPane().add(partnerTextfield, new GridBagConstraints(9, 1, 2, 1, 1.0, 0.0
     ,GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(26, 0, 0, 0), 68, 9));
    this.getContentPane().add(selectButton, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0
     ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(51, 44, 0, 0), 9, 18));
    this.getContentPane().add(modifyButton, new GridBagConstraints(5, 2, 1, 1, 0.0, 0.0
     ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(51, 0, 0, 0), 18, 18));
    this.getContentPane().add(delButton, new GridBagConstraints(6, 2, 1, 1, 0.0, 0.0
     ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(52, 14, 0, 0), 8, 16));
    this.getContentPane().add(exitButton, new GridBagConstraints(10, 2, 3, 1, 0.0, 0.0
     ,GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(51, -1, 0, 15), -14, 17));
    this.getContentPane().add(statusField, new GridBagConstraints(0, 3, 12, 1, 1.0, 0.0
     ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(9, 2, 4, 0), 747, 43));
    this.getContentPane().add(insertButton, new GridBagConstraints(3, 2, 2, 1, 0.0, 0.0
     ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(51, 0, 0, 13), 3, 18));
    this.getContentPane().add(clearButton, new GridBagConstraints(8, 2, 2, 1, 0.0, 0.0
     ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(52, 10, 0, 14), 0, 17));
  }
}
