 /*
 * @author       Arun
 * @version 1.0
 *
 * Development Environment        :  JDeveloper 2.0
 * Name of the Application        :  DateFrame.java
 * Creation/Modification History  :
 *
 *    Arun       30-Dec-1998      Created
 *    Sujatha    15-May-2002      Re-certified on Oracle9i JDeveloper  
 *
 */
package oracle.otnsamples.jdbc.datetype;

import java.awt.TextField;
import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.AdjustmentEvent;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;

import java.util.Calendar;
import java.util.Vector;
import java.util.GregorianCalendar;
import java.text.SimpleDateFormat;

// Swing 1.1 imports
import javax.swing.JLabel;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JFrame;
import javax.swing.JScrollBar;
import javax.swing.ListSelectionModel;
import javax.swing.JTextField;

/**
 * This sample demonstrates the use of JDBC calls to access DATE fields.
 * The user gives a specific departure Date and on pressing SELECT the application
 * retrieves all flights on that departure date.
 */

public class DateFrame extends JFrame {

  /** The main application class which uses this frame */
  DateSample parent;

  /** Date Manipulation variables */
  GregorianCalendar gcal     = new GregorianCalendar();

  /** System date variable */
  java.util.Date    date     = new java.util.Date();

  /** Formatting date */
  SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yy");

  /**  Formatted Date */
  String dateString = formatter.format(date);

  /**  For remembering the last val of deviation from date */
  int lastVal = 0;

  /**  Scrollpane containing JTable */
  JScrollPane flightPane = new JScrollPane();

  /**  The JTable containing the table rows */
  JTable flightTable     = new JTable();

  /** The table model containing the JTable data */
  GenTableModel tableModel;

  // buttons
  JButton exitButton = new JButton();
  JButton selectButton = new JButton();

  // Textfields and labels
  JPanel contentPane = new JPanel();
  JLabel depLabel    = new JLabel();
  JTextField depDate = new JTextField();

  /** Status bar */
  TextField statusField = new TextField();

  /** The departure date scrollbar */
  JScrollBar updownButton = new JScrollBar();

  /** Layout manager */
  GridBagLayout gridBagLayout = new GridBagLayout();

  /**
   * Constructor. Initialises GUI
   */
  public DateFrame(DateSample newParent) {
    try {
      parent = newParent;
      tableInit();      // initialise JTable
      jbInit();         // initialise gui components
      setupListeners(); // setup listeners for the buttons and the scroll bar
      flightPane.repaint();  // Window refresh
    } catch( Exception e ) {
      statusField.setText("Error..!! \n" + e.toString());
    }
  }

  /**
   *  This method actually helps the user about the date of departures available
   */
  public void displayDateLimits(java.util.Date minDate, java.util.Date maxDate) {
    String message = " Departures available between " + formatter.format(minDate) +
                " and " + formatter.format(maxDate);
    putStatus(message);

  }

  /**
   * This method inserts a new row into the JTable
   */
  public void addToJTable( String code, String name, String partner ) {

    // Add the inserted row to the JTable
    Vector newrow = new Vector(); // Vector containing the column values
    newrow.addElement( code );
    newrow.addElement( name );
    newrow.addElement( partner );
    tableModel.insertRow( newrow ); // Add the row to the JTable
    flightPane.repaint();

  }

  /**
   *  JTable initialization. Sets up the column name and the table model
   *  for the JTable
   */
  public void tableInit(){
    // Column Headings
    String[] colHeadings = {"Flight Code", "Departure Time", "Status"};
    // Default Values
    Object[] defaultValues = {"", "", ""};

    // Construct the generic Table model with the column headings, default
    // values with the number of rows to be displayed initially
    tableModel = new GenTableModel(colHeadings,defaultValues, 10);

    // construct the new JTable with the table model constructed above
    flightTable = new JTable(tableModel);

    // set the selection mode for the JTable for the user has to select only
    // one record at a time
    flightTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
  }

  /**
   *  Sets up the listeners that respond to user actions, including button
   *  press events
   */
  public void setupListeners() {
    // Setup the select button listener
    selectButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        parent.dispatchEvent("SELECT");
      }
    });
    
    // Setup the EXIT button listener
    exitButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        parent.dispatchEvent("EXIT");
      }
    });

    // Setup listener for the vertical scroll bar button click
    updownButton.addAdjustmentListener(new java.awt.event.AdjustmentListener() {
      public void adjustmentValueChanged(AdjustmentEvent e) {
        updownButton_adjustmentValueChanged(e);
      }
    });
  }

  /**
   * Increments or decrements the departure dates based on the scrollbar
   * presses
   */
  void updownButton_adjustmentValueChanged(AdjustmentEvent e) {
    gcal.setTime(date); // Set the calendar to the current date

    // if the value is less then increment the date value
    if( lastVal > e.getValue() )  {
      gcal.add(Calendar.DATE, 1);   // increment the calendar by one day
    } else {
      gcal.add(Calendar.DATE, -1);  // else decrement the calendar by one day
    }
    date = gcal.getTime();                   // get the new date object
    dateString = formatter.format(date);   // format the date
    depDate.setText(dateString);             // update the text field
    lastVal = e.getValue();
  }

  /**
   * Clears status field
   */
  public void clearStatus( ) {
    statusField.setText("");
  }

  /**
   * Displays status on status field
   */
  public void putStatus( String status ) {
    statusField.setText(status);
  }

  /**
   * Appends status to status field
   */
  public void appendStatus(String status) {
    statusField.setText(statusField.getText() + "\n" + status);
  }
  /**
  * Initializes other GUI Components.
  **/
  public void jbInit() throws Exception {

    this.setContentPane(contentPane);
    this.setResizable(false);
    this.setTitle("Illustrating DATE data type using JDBC");
    this.setFont(new Font("Dialog", 1, 16));
    this.getContentPane().setLayout(gridBagLayout);
    this.setSize(new Dimension(642, 286));
    this.addWindowListener(new java.awt.event.WindowAdapter() {
      public void windowClosing(WindowEvent e) {
        parent.dispatchEvent("EXIT");
      }
    });
    exitButton.setText("EXIT");
    exitButton.setFont(new Font("Dialog", 1, 16));
    statusField.setBackground(Color.lightGray);
    statusField.setFont(new Font("Monospaced", 0, 12));
    statusField.setEditable(false);
    updownButton.setMinimum(-100);
    selectButton.setFont(new Font("Dialog", 1, 16));
    selectButton.setText("SELECT");
    depLabel.setText("Departure Date");
    depLabel.setFont(new Font("Dialog", 1, 16));
    depDate.setFont(new Font("Dialog", 1, 16));
    depDate.setText(dateString);
    this.getContentPane().add(depLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(12, 17, 0, 8), 4, 9));
    this.getContentPane().add(depDate, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(10, 1, 0, 6), 164, 11));
    this.getContentPane().add(selectButton, new GridBagConstraints(4, 1, 1, 2, 0.0, 0.0
            ,GridBagConstraints.SOUTH, GridBagConstraints.NONE, new Insets(0, 70, 0, 3), 12, 2));
    this.getContentPane().add(exitButton, new GridBagConstraints(5, 1, 1, 2, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(16, 0, 0, 14), 34, 2));
    this.getContentPane().add(statusField, new GridBagConstraints(0, 3, 6, 1, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(16, 10, 10, 11), 619, 30));
    this.getContentPane().add(flightPane, new GridBagConstraints(0, 0, 6, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(11, 11, 0, 11), 161, -295));
    flightPane.getViewport().add(flightTable, null);
    this.getContentPane().add(updownButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(11, 6, 0, 37), 0, 0));
    this.setBackground(Color.lightGray);
  }
}



