/*
 * @author  Feroz
 * @version 1.0
 *
 * Development Environment        :  JDeveloper 2.0
 * Name of the Application        :  DynamicSqlFrame.java
 * Creation/Modification History  :
 *
 *    Feroz       08-Mar-1999      Created
 *    Sujatha     22-May-2002      Re-certified on Oracle9i JDeveloper   
 *
 */
 
package oracle.otnsamples.jdbc.dynamicsql;

import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Vector;

/** SWING version 1.1 imports */
import javax.swing.JLabel;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.JScrollPane;
import javax.swing.JFrame;
import javax.swing.ListSelectionModel;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.ListSelectionEvent;

/**
 * This class handles the GUI for the DynamicSqlSample application.
 * This class also extends GenTableModel to handle dynamically changing JTables
 */

public class DynamicSqlFrame extends JFrame {

  /**  Handle to the sample main class, in order to dispatch GUI events */
  DynamicSqlSample parent;

  /** Table name selected by user for querying */
  String tableName;

  /** List of columns selected from the table for querying */
  String[] selectedColumns;

  /** For the Jtable containing the information about all the tables */
  DynamicSqlTableModel tableNameModel;// The model for the table
  JScrollPane tableNameScrollPane = new JScrollPane();
  JTable tableNamesTable = new JTable();

  /** various text fields for status query and where clause */
  JTextField statusField = new JTextField();
  JTextField restrictionTextfield = new JTextField();
  JTextField queryTextfield = new JTextField();

  /** Buttons for select sql and exit */
  JButton exitButton = new JButton();
  JButton selectButton = new JButton();

  /** For the table containing the name of the columns */
  DynamicSqlTableModel columnNameModel;
  JScrollPane columnNameScrollPane = new JScrollPane();
  JTable columnNamesTable = new JTable();

  /** For the table containing the result of the query operation */
  DynamicSqlTableModel resultNameModel ;
  JScrollPane resultsScrollPane = new JScrollPane();
  JTable selectionResultTable = new JTable();

  /** various labels for table column query etc */
  JLabel tableLabel = new JLabel();
  JLabel columnLabel = new JLabel();
  JLabel queryLabel = new JLabel();
  JLabel queryRestrictionLabel = new JLabel();
  JLabel queryResultsLabel = new JLabel();

  JLabel whereClause = new JLabel();
  GridBagLayout gridBagLayout1 = new GridBagLayout();
  
  /** 
   *  The constructor for DynamicSqlFrame class
   */
  public DynamicSqlFrame( DynamicSqlSample newParent ) {
    parent = newParent;
    try {
      // Initializing of various tables
      tableInit();
      columnsTableInit();
      resultsTableInit();

      jbInit();
      setupListeners();
    } catch( Exception e ) {
      e.printStackTrace();
    }
  }

  /**
   *  Sets up the listeners that respond to user actions, including button
   *  press and row selection in the JTable
   */
  public void setupListeners() {
    // Set up the table row selection listener. Only single row selection is
    // allowed
    tableNamesTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    tableNamesTable.getSelectionModel().addListSelectionListener(
    new ListSelectionListener() {
      public void valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        // Setup the action to be performed when a row selection event has
        // been captured. Calls printData to display the row values in the
        // Textfields
        int selectedRow = lsm.getMinSelectionIndex();
        if( selectedRow >= 0 ) {
          tableName = (String) tableNameModel.getValueAt( selectedRow, 0 );
          tableNameScrollPane.repaint();
          columnNameModel.clearTable(); // Clear JTable in GUI
          parent.dispatchEvent("DISPLAY_COLUMNS");
          columnNamesTable.clearSelection();
          selectedColumns = null;
        }
      }
    });
    
    columnNamesTable.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
    columnNamesTable.getSelectionModel().addListSelectionListener(
      new ListSelectionListener() {
        public void valueChanged(ListSelectionEvent e) {
          ListSelectionModel lsm = (ListSelectionModel)e.getSource();
          // Setup the action to be performed when a row selection event has
          // been captured. Calls printData to display the row values in the
          // Textfields
          if(e.getValueIsAdjusting())
            return;
          if( lsm.isSelectionEmpty() ) {
            resultNameModel.setDefault();
            queryTextfield.setText(" ");
            selectedColumns = null;
            return;
          }
          int[] selectRows = columnNamesTable.getSelectedRows();
          selectedColumns = new String[selectRows.length];
          for( int i = 0; i < selectRows.length; i++ ) {
            selectedColumns[i] = new String((String) columnNameModel.getValueAt(
            selectRows[i],0));
          }
          resultNameModel.changeStructure(selectedColumns,0);
          queryTextfield.setText("SELECT  " + makeStringOfAllColumns() + " "
             + "FROM " + tableName);
          tableNameScrollPane.repaint();
      }
    });
    
    // Setup the select button listener
    selectButton.addActionListener(new java.awt.event.ActionListener(){
      public void actionPerformed(ActionEvent evt){
        // Setup the action to be performed when the select button is
        // pressed. Calls the selectRecord method which performs the select
        // operation
        if( selectedColumns == null )
          putStatus("No column selected");
        else {
          clearStatus();
          resultNameModel.clearTable(); // Clear JTable in GUI
          parent.dispatchEvent("SELECT");
        }
      }
    });
    
    // Setup the exit button listener
    exitButton.addActionListener(new java.awt.event.ActionListener(){
      public void actionPerformed(ActionEvent evt){
        parent.dispatchEvent("EXIT");
      }
    });
    
    // The window exit listener
    this.addWindowListener(new java.awt.event.WindowAdapter() {
      public void windowClosing(WindowEvent e) {
        parent.dispatchEvent("EXIT");
      }
    });
  }

  /**
   *  JTable initialization for table holding name of tables. Sets up the
   *  column name and the table model for the JTable
   */
  public void tableInit(){
    String[] cols = {"Table List"};
    Object[] defaultv = {""};
    tableNameModel  = new DynamicSqlTableModel( cols, defaultv, 0);
    tableNamesTable = new JTable( tableNameModel );
    tableNamesTable.setSelectionMode( ListSelectionModel.SINGLE_SELECTION );
  }

  /**
   *  JTable initialization for table showing column names. Sets up the column
   *  name and the table model for the JTable
   */
  public void columnsTableInit(){
    String[] cols      = {"Column Names"};
    Object[] defaultv  = {""};
    columnNameModel  = new DynamicSqlTableModel( cols, defaultv, 0);
    columnNamesTable = new JTable( columnNameModel );
    columnNamesTable.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
  }

  /**
   *  JTable initialization for the query results. Sets up the column name
   *  and the table model for the JTable
   */
  public void resultsTableInit(){
    String[] cols     = {""};
    Object[] defaultv = {""};
    selectedColumns = null;
    resultNameModel = new DynamicSqlTableModel( cols, defaultv, 0);
    selectionResultTable = new JTable( resultNameModel );
    selectionResultTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
  }

  /**
   * This method inserts a new row into the JTable holding the table names
   */
  public void addToJTable( String tableName ) {
    // Add the inserted row to the JTable
    Vector newrow = new Vector();       // Vector containing the column values
    newrow.addElement(tableName);
    tableNameModel.insertRow(newrow); // Add the row to the JTable
    tableNameScrollPane.repaint();
  }

  /**
   * This method inserts a new row into the Jtable holding column names
   */
  public void addToJTable1( String columnName ) {

    // Add the inserted row to the JTable
    Vector newrow = new Vector(); // Vector containing the column values
    newrow.addElement(columnName);
    columnNameModel.insertRow(newrow); // Add the row to the JTable
    columnNameScrollPane.repaint();

  }

  /**
   * This method inserts a new row into the JTable holding the query results
   */
  public void addToResultsTable(String[] columnNames) {
    // Add the inserted row to the JTable
    Vector newrow = new Vector(); // Vector containing the column values
    for( int i = 0; i < columnNames.length; i++ ) {
      newrow.addElement(columnNames[i]);
    }
    resultNameModel.insertRow(newrow); // Add the row to the JTable
    resultsScrollPane.repaint();
  }

  /**
   *  This method combines all the column names into one string so
   *  that it can be used for executing the query
   */
  public String makeStringOfAllColumns() {
    String finalString;
    if( selectedColumns.length == 0 ) {
      finalString = new String ("");
      return finalString;
    }
    finalString = new String(selectedColumns[0]) ;
    for(int i = 1; i < selectedColumns.length; i++ ) {
      finalString= new String( finalString + "," + selectedColumns[i] );
    }
    return finalString;
  }

  /**
   *  This function add the selected column to the list of selected
   *  Columns
   */
  public void addInSelectedColumns(String columnName) {
    String[] selectedCols = selectedColumns;
    if( selectedColumns == null) {
      selectedColumns = new String[1];
      selectedColumns[0] = new String(columnName);
      return ;
    }
    selectedColumns = new String[selectedCols.length + 1];
    for( int i = 0; i < selectedCols.length; i++ ) {
      selectedColumns[i] = new String(selectedColumns[i]);
    }
    selectedColumns[selectedCols.length] = new String(columnName);
  }

  /**
   * Clears status field
   */
  public void clearStatus( ) {         
    statusField.setText("");
  }

  /**
   * Displays status on status field
   */  
  public void putStatus( String status ) { 
    statusField.setText(status);
    statusField.setScrollOffset(0);
  }

  /**
   * Appends status to status field
   */    
  public void appendStatus(String status) { 
    statusField.setText(statusField.getText() + "\n" + status);
    statusField.setScrollOffset(0);
  }

  /**
   * This method initializes all the GUI components
   */
  public void jbInit() throws Exception {
    this.getContentPane().setLayout(gridBagLayout1);
    this.setSize(new Dimension(669, 622));
    tableNamesTable.setBounds(new Rectangle(23, 31, 194, 193));
    statusField.setBackground(Color.lightGray);
    exitButton.setText("EXIT");
    exitButton.setFont(new Font("Dialog", 1, 16));
    tableLabel.setText("Tables");
    tableLabel.setFont(new Font("Dialog", 1, 16));
    columnLabel.setText("Columns");
    columnLabel.setFont(new Font("Dialog", 1, 16));
    queryLabel.setText("SQL Query");
    queryLabel.setFont(new Font("Dialog", 1, 16));
    queryResultsLabel.setText("Query Results");
    queryResultsLabel.setFont(new Font("Dialog", 1, 16));
    whereClause.setText("WHERE CLAUSE ");
    queryRestrictionLabel.setText("Query Restriction");
    queryRestrictionLabel.setFont(new Font("Dialog", 1, 16));
    selectButton.setText("SELECT");
    selectButton.setFont(new Font("Dialog", 1, 16));
    this.setTitle("Dynamic Sql Illustration");
    this.getContentPane().add(tableLabel, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(8, 16, 0, 0), 76, 9));
      this.getContentPane().add(columnLabel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(8, 21, 0, 0), 47, 9));
      this.getContentPane().add(queryRestrictionLabel, new GridBagConstraints(6, 0, 3, 2, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(8, 21, 0, 0), 18, 16));

    this.getContentPane().add(tableNameScrollPane, new GridBagConstraints(0, 1, 4, 5, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 8, 0, 0), -242, -185));
    tableNameScrollPane.getViewport().add(tableNamesTable, null);
      this.getContentPane().add(columnNameScrollPane, new GridBagConstraints(4, 2, 2, 4, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 20, 0, 0), -289, -192));
    columnNameScrollPane.getViewport().add(columnNamesTable, null);
    this.getContentPane().add(restrictionTextfield, new GridBagConstraints(6, 3, 5, 1, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(15, 22, 0, 6), 220, 43));
    this.getContentPane().add(selectButton, new GridBagConstraints(6, 4, 2, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(29, 23, 0, 0), 20, 24));
    this.getContentPane().add(exitButton, new GridBagConstraints(8, 4, 2, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(29, 7, 0, 0), 17, 24));
    this.getContentPane().add(queryLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0
            ,GridBagConstraints.NORTHEAST, GridBagConstraints.NONE, new Insets(5, 14, 20, 0), 22, 16));
    this.getContentPane().add(queryTextfield, new GridBagConstraints(2, 6, 10, 2, 1.0, 0.0
            ,GridBagConstraints.NORTHWEST, GridBagConstraints.HORIZONTAL, new Insets(7, 9, 14, 9), 519, 35));
    this.getContentPane().add(queryResultsLabel, new GridBagConstraints(0, 7, 2, 2, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(8, 12, 0, 0), 6, 14));
    this.getContentPane().add(resultsScrollPane, new GridBagConstraints(0, 9, 11, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 10, 0, 0), 188, -244));
    resultsScrollPane.getViewport().add(selectionResultTable, null);
    this.getContentPane().add(statusField, new GridBagConstraints(0, 10, 11, 1, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(10, 8, 2, 9), 650, 29));
    this.getContentPane().add(whereClause, new GridBagConstraints(6, 1, 1, 2, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 24, 0, 0), 0, 6));
  }

  /**
   * Extention of GenTableModel implementation
   */
  class DynamicSqlTableModel extends GenTableModel {

    /**
     * Constructor that call the parent constructor
     */
    public DynamicSqlTableModel( String columns[], Object defaultv[], int rows ) {
      super( columns, defaultv, rows);
    }

    /**
     * Change the table structure
     */
    public void changeStructure(String columns[],int rows) {
     // Initialize number of columns and column headings
     columnNames = new String[columns.length];
      for (int i = 0; i < columns.length; i++)
        columnNames[i] = new String(columns[i]);

      // Instantiate Data vector, and fill it up with default values
      data = new Vector();
      for( int i = 0; i < rows; i++) {
        Vector cols = new Vector();
        for( int j = 0; j < columns.length; j++ )
          cols.addElement("");
        data.addElement(cols);
      }
      super.fireTableStructureChanged();
    }

    /**
     * When no columns are selected then the query results table is
     * initialized to this
     */
    public void setDefault() {
      columnNames = new String[1];
      columnNames[0] = new String("");
      data = new Vector();
      super.fireTableStructureChanged();
    }
  }
}

