 /*
  * @author  rsundara.in
  * @version 1.0
  *
  * Development Environment        :  Oracle9i JDeveloper
  * Name of the Application        :  LongRawFrame.java
  * Creation/Modification History  :
  *
  * rsundara.in       28-Dec-1998      Created
  * neshastr		      25-May-2002	     Re-certified on Oracle9i JDeveloper
  *
  */
package oracle.otnsamples.jdbc.longraw;

import java.util.Vector;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.MediaTracker;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;

  
import javax.swing.ListSelectionModel;
import javax.swing.JTextField;
import javax.swing.JLabel;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.JScrollPane;
import javax.swing.JFrame;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

/**
 * This class handles the gui for LongRawSample Application
 */
public class LongRawFrame extends JFrame {

  // The main application class which uses this frame
  LongRawSample parent;

  // Used for image manipulation
  MediaTracker tracker;     // Takes care of the loading of the image
  Image image = null;         // Holds the logo(image) of the selected airline
  Panel panel = new Panel();// The image container

  // JTable related variables

  JTable table = new JTable(); // The JTable which displays the database rows
  GenTableModel tablemodel;    // Table Model for the JTable
  JScrollPane scrollpane = new JScrollPane(); // The scrollpane holding the JTable

  JTextField statusbar = new JTextField(); // Status Bar

  // Other gui elements
  JLabel label = new JLabel();
  JButton exit = new JButton();

  GridBagLayout gridBagLayout = new GridBagLayout(); // Layout manager

  /**
   *  Constructor. Initializes the JTable and other gui components.
   */
  public LongRawFrame(LongRawSample parent) {
    try {
      this.parent = parent;
      tableInit();      // JTable initializations
      jbInit();         // Other gui components initializations
      setupListeners(); // Sets up the event listeners and actions
	    positionScreen();
	    setVisible(true);
    } catch (Exception e) {  // Trap general errors
      e.printStackTrace();
    }
  }

  /**
   *  This method inserts a new row into the JTable
   */
  public void addToJTable(String code,String name,String partner) {

    // Add the inserted row to the JTable
    Vector newrow = new Vector(); // Vector containing the column values
    newrow.addElement(code);
    newrow.addElement(name);
    newrow.addElement(partner);
    tablemodel.insertRow(newrow);   // Add the row to the JTable
    scrollpane.repaint();
  }

  /**
   * This method  loads the image from the local directory and draws the image
   * file on the front end panel
   */

  public void drawLogo(String str){
    try {
      //Load the image from the image file
      tracker=new MediaTracker(this);
      image=Toolkit.getDefaultToolkit().getImage(str+".gif");
      tracker.addImage(image,0);
      tracker.waitForID(0);

      // Draw the image
      Graphics g=panel.getGraphics();     // Getting the Graphics context
      g.drawImage(image,50,30,this);      // Drawing the logo
    } catch( InterruptedException ex ) {  // Trap Interrupted error
      putStatus(ex.toString());
    }
 }

  /**
   *  JTable initialization. Sets up the column name and the table model
   *  for the JTable
   */
  public void tableInit(){
    // Column Headings of the JTable
    String[] colHeadings={"Airline Code","Airline Name","Partner"};

    Object[] defaultValues={"","",""};

    // Instantiate the table model and the JTable
    tablemodel =new GenTableModel(colHeadings,defaultValues,5);
    table=new JTable(tablemodel);
  }

  /**
   *  Sets up the listeners that respond to user actions, including button
   *  press
   */
  public void setupListeners() {
    // Set up the table row selection listener. Only single row selection is
    // allowed
    table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    table.getSelectionModel().addListSelectionListener(
      new ListSelectionListener() {
        public void valueChanged(ListSelectionEvent e) {
          ListSelectionModel lsm = (ListSelectionModel)e.getSource();
          if (!lsm.isSelectionEmpty()) {
            // Setup the action to be performed when a row selection event has
            // been captured. Calls printData to display the row values in the
            // Textfields
            int selectedRow = lsm.getMinSelectionIndex();
            // Get the airline Code for the selected row
            TableModel model=table.getModel();
            parent.dispatchEvent("SELECT");
          }
        }
      });

    // Listener for exit button
    exit.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e){
        parent.dispatchEvent("EXIT");
      }
    });
  }

  /**
   * This method  appends string messages to the existing messages in the
   * status bar
   */
  public void appendStatus(String status) {
    statusbar.setText(statusbar.getText()+ "\n" + status);
    statusbar.setScrollOffset(0);
  }

  /**
   * This method displays string messages in the status bar
   */
  public void putStatus(String message) {
    statusbar.setText(message);
    statusbar.setScrollOffset(0);
  }
  
  /**
   * This method clears the status bar
   */
  public void clearStatus() {
    statusbar.setText(" ");
  }

  /**
   * Initializes gui components on the JFrame
   */
  public void jbInit() throws Exception {
    this.getContentPane().setLayout(gridBagLayout);
    this.setSize(new Dimension(475, 392));
    this.setTitle("Illustrating LONG RAW Data type through JDBC");
    panel.setBackground(Color.black);
    statusbar.setFont(new Font("Monospaced", 0, 12));
    statusbar.setDisabledTextColor(Color.black);
    statusbar.setEditable(false);
    label.setText("AIRLINE LOGO");
    label.setFont(new Font("Dialog", 0, 16));
    exit.setText("EXIT");
    exit.setFont(new Font("Dialog", 0, 16));
    this.getContentPane().add(scrollpane, new GridBagConstraints(0, 0, 3, 1,
     1.0, 1.0,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets
        (3, 17, 0, 0), 21, -257));
    scrollpane.getViewport().add(table, null);
    this.getContentPane().add(panel, new GridBagConstraints(0, 2, 2, 1, 1.0,
     1.0,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets
        (0, 17, 0, 0), 312, 160));
    this.getContentPane().add(statusbar, new GridBagConstraints(0, 3, 4, 1,
      1.0, 0.0,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets
        (7, 7, 3, 7), 505, 19));
    this.getContentPane().add(label, new GridBagConstraints(0, 1, 1, 1,
      0.0, 0.0,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets
       (0, 17, 0, 0), 34, 14));
    this.getContentPane().add(exit, new GridBagConstraints(2, 2, 1, 1,
      0.0, 0.0,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets
      (135, 12, 0, 0), 83, 9));

    this.setSize(new Dimension(534, 440));
    this.addWindowListener(new java.awt.event.WindowAdapter() {
    public void windowClosing(WindowEvent e) {
        parent.dispatchEvent("EXIT");
      }
    });
  }
  
  /**
   * Repositions the frame to the center of the window
   */  
  private void positionScreen() {
    
    // Get the screen size
    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    
    // Get the frame size
    Dimension frameSize = getSize();
    if(frameSize.height > screenSize.height) {
      frameSize.height = screenSize.height;
    }
    if(frameSize.width > screenSize.width) {
      frameSize.width = screenSize.width;
    }
    
    // Find the center of the screen and reposition the frame
    setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
  }
}