/*
 * @author  rsundara.in
 * @version 1.0
 *
 * Development Environment        :  Oracle9i JDeveloper
 * Name of the Application        :  PopulateTable.java
 * Creation/Modification History  :
 *
 * rsundara.in       29-Dec-1998      Created
 * neshastr          22-May-2002      Re-certified on Oracle9i JDeveloper
 *
 */
package oracle.otnsamples.jdbc.longraw;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Properties;

import java.sql.Connection;
import java.sql.Statement;
import java.sql.SQLException;
import java.sql.PreparedStatement;

import java.io.FileInputStream;
import java.io.File;
import java.io.IOException;

import oracle.jdbc.pool.OracleDataSource;
/**
 * This sample creates a table airline_long_raw_table in the database
 * with 3 varchar2 columns and  1 long raw column.
 * The columns are
 *    code varchar2(2)
 *    name varchar2(40)
 *    partner varchar2(1)
 *    airline_logo long raw
 *
 * After creating the table, it also populates data into the table
 *
 * The following methods contain JDBC calls and encapsulate database access:
 *   *** createTable method, creates the AIRLINE_LONG_RAW_TABLE
 *   *** insertData method inserts a row into the AIRLNE_LONG_RAW_TABLE
 *
 */
public class PopulateTable {

  Connection connection; // The database connection object

 /**
  *  Main entry point for the class. Sets up the database connection and
  *  creates the AIRLINE_LONG_RAW_TABLE table, and populates it.
  */
 public static void main(String[] args) {
   PopulateTable pop=new PopulateTable();  // Instantiate class
   pop.dbConnection(); // Setup database connection
   pop.createTable();  // Create the AIRLINE_LONG_RAW_TABLE table

   try{
      // Insert rows into the table
      pop.insertData("A1","WindAirways","I","WindAirways.gif");
      pop.insertData("A2","GreenLableAirways","B","GreenLableAirways.gif");
      pop.insertData("A3","FlyHighAirways","I","FlyHighAirways.gif");
      pop.insertData("A4","TopSurferAirlines","B","TopSurferAirlines.gif");
      pop.insertData("A5","JumboAirways","B","JumboAirways.gif");

      System.out.println("Inserted data into the db");
    }
    catch(Exception ex){
      System.out.println("Error in inserting data. \n"+ex.toString());
    }
  }


  /**
   * This method reads a properties file which is passed as
   * the parameter to it and load it into a java Properties
   * object and returns it.
   */
  
  public static Properties loadParams(String file) throws IOException {
    
    // Loads a ResourceBundle and creates Properties from it
    Properties prop = new Properties();
    ResourceBundle bundle = ResourceBundle.getBundle(file);
    Enumeration enum = bundle.getKeys();
    String key = null;
    while(enum.hasMoreElements()) {
      key = (String)enum.nextElement();
      prop.put(key, bundle.getObject(key));
    }
    return prop;
  }
  
/**
   * Creates a database connection object using DataSource object. Please 
   * substitute the database connection parameters with appropriate values in
   * Connection.properties file
   */
  public boolean dbConnection() {
    try {
 
      // Load the properties file to get the connection information
      Properties prop = this.loadParams("Connection");
 
      // Create a OracleDataSource instance
      OracleDataSource ods = new OracleDataSource();
 
      // Sets the driver type
      ods.setDriverType("thin");
 
      // Sets the database server name
      ods.setServerName((String)prop.get("HostName"));
 
      // Sets the database name
      ods.setDatabaseName((String)prop.get("SID"));
 
      // Sets the port number
      ods.setPortNumber(new Integer((String)prop.get("Port")).intValue());
 
      // Sets the user name
      ods.setUser((String)prop.get("UserName"));
 
      // Sets the password
      ods.setPassword((String)prop.get("Password"));
      connection = ods.getConnection();
 
    } catch(SQLException ex) { // Trap SQL errors
        System.out.println(
                     "Error in Connecting to the Database "+'\n'+ex.toString());
    } catch(IOException ex) { // Trap SQL errors
        System.out.println(
                     "Error in reading the properties file "+'\n'+ex.toString());
    }
 
    // Return false if failed to obtain connection object
    if( connection != null )
        return true;
        
    return false;
  }
 /**
  * This method creates the table AIRLINE_LONG_RAW_TABLE in the database
  */
 public void createTable(){

   // Drop the table if it already exists
   try {
      // Statement object for executing the query
      Statement stmt = connection.createStatement();
      stmt.execute("drop table AIRLINE_LONG_RAW_TABLE"); // Execute the statement
      System.out.println("Table dropped");
      stmt.close();
   } catch (Exception ex) {}

   // Create the table
   try{
      // Statement object for executing the query
      Statement stmt = connection.createStatement();

      String query="create table AIRLINE_LONG_RAW_TABLE (code varchar2(2),name varchar2(40),partner varchar2(1),airline_logo long raw )";
      stmt.executeQuery(query);  // Execute the statement
      System.out.println("Table created");
      stmt.close();
   } catch(SQLException ex){
     System.out.println("Error creating table. \n"+ex.toString());
   }
 }

/**
 * This method inserts contents of the specified file into the
 * AIRLINE_LOGO column in the AIRLINE_LONG_RAW_TABLE
 */
 public void insertData(String code,String name,
                        String partner,String logoname)
             throws Exception {

   //Create a File to read data from the specified text file (logoname)
   File file = new File(getClass().getClassLoader().getResource(logoname).getFile());

   // Prepare the statement for inserting a row into the AIRLINE_LONG_RAW_TABLE
   PreparedStatement pstmt=connection.prepareStatement(
      "insert into AIRLINE_LONG_RAW_TABLE(Code,Name,Partner,Airline_Logo) "+
      "values(?, ?, ?, ?)");

   // Bind the parameter values for the above statement
   pstmt.setString(1,code);  // Bind CODE
   pstmt.setString(2,name);  // Bind NAME
   pstmt.setString(3,partner); // Bind PARTNER

   // Bind the AIRLINE_LOGO column to an input stream that returns the
   // binary data to be inserted into the LONGRAW column
   pstmt.setBinaryStream(4,new FileInputStream(file),(int)file.length ());


   pstmt.execute(); // Execute the statement

 }

}
