/*
 * @author  rsundara.in
 * @version 1.0
 *
 * Development Environment        :  Oracle 9i JDeveloper
 * Name of the Application        :  ThreadFrame.java
 * Creation/Modification History  :
 *
 * rsundara.in       16-Jan-1999     Created
 * Reghu             15-May-2002     Modified  
 *
 */

package oracle.otnsamples.jdbc.thread;

// Java AWT classes
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.TextField;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;

import java.util.Vector;

// SWING classes
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JButton;

/**
 * This class is the implementation of ThreadSample Application
 */
public class ThreadFrame extends JFrame {

  ThreadSample parent;  // Main sample class to which events are passed

  // JButtons for suspend/resume,start,exit
  private JButton bsusres, bstart, bexit;

  // JLabels used for displaying the types of rooms
  private JLabel lrowfetched, lrowsdisplayed, ltotal, lavgrate, ldouble;
  private JLabel lking, lorcl, lother, lqueen, lsglb, lsuit;

  // Layout manager for the frame
  private GridBagLayout gridBagLayout1 = new GridBagLayout();

  // TextFields used for displaying the avg rate and the no of rooms
  TextField trowfetched, trowdisplayed, statusbar, tdouble, tdoublerate;
  TextField tking, tkingrate, torcl, torclrate, tothers, tothersrate;
  TextField tqueen, tqueenrate, tsglb, tsglbrate, tsuit, tsuitrate;

  // JTable related variables
  GenTableModel tableData;   // The generic table model for displaying  data
  JScrollPane scrollpane = new JScrollPane(); //Scrollpane to hold table
  JTable table = new JTable();

 /**
  * Constructor. Initializes the JTable and other gui components.
  */

 public ThreadFrame(ThreadSample parent) {
    try {
      this.parent= parent;
      tableInit();        // Constructs the table
      jbInit();           // Initialize other gui components
      setupListeners();   // Setting up actionlisteners for components
    } catch (Exception e) { // Trap general Errors
      e.printStackTrace();
    }
 }

  /**
   * This method inserts a new row into the JTable
   */
  public void addToTableData(String code,String name,Integer rate) {

   // Add the inserted row to the JTable
   Vector newrow = new Vector(); // Vector containing the column values
   newrow.addElement(code);
   newrow.addElement(name);
   newrow.addElement(rate);
   tableData.insertRow(newrow);   // Add the row to the JTable
  }

  /**
   * Method to update gui before the database fetch can proceed
   */
  public void beforeFetch() {
    bsusres.setEnabled(true);
    bstart.setEnabled(false);
    bexit.setEnabled(true);
    tableData.clearTable();
  }


 /**
  * JTable initialization. Sets up the column name and the table model
  * for the JTable
  */
 public void tableInit(){
     // This array holds the names of the table columns
     String[] colHeadings={ "Hotel Name","Room Type","Rate" };

     // This array holds the default values of the table
     Object[] defaultValues={ " "," ",new Integer(0) };

     // construct the generic Table model with the column headings, default
     // values with the number of rows to be displayed initially
     tableData = new GenTableModel(colHeadings,defaultValues, 10);

     // construct the new JTable with the table model constructed above
     table = new JTable(tableData);
 }

 /**
  * Sets up the listeners that respond to user actions, including button
  * press                                 *
  */
 public void setupListeners(){
  // setting up action event for the bstart button
  bstart.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e){
         putStatus(" ");
         parent.dispatchEvent("START THREADS");
         bexit.setEnabled(false);
      }
  });
  // setting up action event for the bexit button
  bexit.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        parent.dispatchEvent("EXIT");
      }
  });
  // setting up action event for the bsusres button
  bsusres.addActionListener(new java.awt.event.ActionListener() {
      // boolean variable to check suspended status of thread
      // boolean suspendresume=false;
      public void actionPerformed(ActionEvent e) {
        parent.dispatchEvent("SUSPEND/RESUME THREADS");
      }
  });

 }

 /**
  * Status field message display handlers
  */
 public void appendStatus(String status){
   statusbar.setText(status + ":" + statusbar.getText());
 }

 public void putStatus(String message){
    statusbar.setText(message);
 }
 public void clearStatus(){
    statusbar.setText(" ");
 }

 /**
  * Initialize all the gui components and the layout
  */
 public void jbInit() throws Exception {
    this.getContentPane().setLayout(gridBagLayout1);
    this.setTitle("Illustrating Threads using JDBC");
    ltotal = new JLabel();
    ltotal.setForeground(Color.black);
    lavgrate = new JLabel();
    lavgrate.setForeground(Color.black);
    ldouble = new JLabel();
    ldouble.setForeground(Color.black);
    lking = new JLabel();
    lking.setForeground(Color.black);
    lorcl = new JLabel();
    lorcl.setForeground(Color.black);
    lother = new JLabel();
    lother.setForeground(Color.black);
    lqueen = new JLabel();
    lqueen.setForeground(Color.black);
    lsglb = new JLabel();
    lsglb.setForeground(Color.black);
    lsuit = new JLabel();
    lsuit.setForeground(Color.black);
    tdouble = new TextField();
    tdoublerate = new TextField();
    tking = new TextField();
    tkingrate = new TextField();
    torcl = new TextField();
    torclrate = new TextField();
    tothers = new TextField();
    tothersrate = new TextField();
    tqueen = new TextField();
    tqueenrate = new TextField();
    tsglb = new TextField();
    tsglbrate = new TextField();
    tsuit = new TextField();
    tsuitrate = new TextField();
    lrowfetched = new JLabel();
    lrowfetched.setForeground(Color.black);
    lrowsdisplayed = new JLabel();
    lrowsdisplayed.setForeground(Color.black);
    trowfetched = new TextField();
    trowdisplayed = new TextField();
    bsusres = new JButton();
    bstart = new JButton();
    bexit = new JButton();
    statusbar = new TextField();
    lrowsdisplayed.setFont(new Font("Dialog", 1, 12));
    lrowfetched.setFont(new Font("Dialog", 1, 12));
    lavgrate.setFont(new Font("Dialog", 1, 12));
    ltotal.setFont(new Font("Dialog", 1, 12));
    lking.setFont(new Font("Dialog", 1, 12));
    lorcl.setFont(new Font("Dialog", 1, 12));
    lother.setFont(new Font("Dialog", 1, 12));
    lqueen.setFont(new Font("Dialog", 1, 12));
    lsglb.setFont(new Font("Dialog", 1, 12));
    lsuit.setFont(new Font("Dialog", 1, 12));
    ldouble.setFont(new Font("Dialog", 1, 12));
    statusbar.setFont(new Font("Dialog", 1, 12));
    statusbar.setEditable(false);
    statusbar.setBackground(Color.lightGray);
    statusbar.setForeground(Color.black);
    ltotal.setText("Total");
    lavgrate.setText("Avg Rate");
    ldouble.setText("DOUBLE");
    lking.setText("KING");
    lorcl.setText("ORCL");
    lother.setText("OTHERS");
    lqueen.setText("QUEEN");
    lsglb.setText("SGLB");
    lsuit.setText("SUIT");
    lrowfetched.setText("Rows Fetched");
    lrowsdisplayed.setText("Rows Displayed");
    bsusres.setText("bsusres");
    bsusres.setText("SUSPEND / RESUME");
    bsusres.setFont(new Font("Dialog", 1, 12));
    bsusres.setEnabled(false);
    bstart.setText("bstart");
    bstart.setText("START");
    bstart.setFont(new Font("Dialog", 1, 12));
    bexit.setText("bexit");
    bexit.setText("EXIT");
    bexit.setFont(new Font("Dialog", 1, 12));
    bexit.setEnabled(true);
    ltotal.setText("Total");
    this.setSize(new Dimension(607, 429));
    this.addWindowListener(new java.awt.event.WindowAdapter() {
      public void windowClosing(WindowEvent e) {
        parent.dispatchEvent("EXIT");
      }
    });
    this.getContentPane().add(scrollpane, new GridBagConstraints(0, 0, 5, 8, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(7, 12, 0, 12), -192, -212));
    scrollpane.getViewport().add(table, null);
    this.getContentPane().add(ltotal, new GridBagConstraints(6, 0, 2, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(7, 25, 0, 0), 29, 16));
    this.getContentPane().add(lavgrate, new GridBagConstraints(8, 0, 3, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(7, 9, 0, 0), 58, 9));
    this.getContentPane().add(ldouble, new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.SOUTH, GridBagConstraints.NONE, new Insets(0, 4, 0, 4), 0, 0));
    this.getContentPane().add(lking, new GridBagConstraints(5, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 17, 0, 0), 0, 0));
    this.getContentPane().add(lorcl, new GridBagConstraints(5, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 13, 0, 0), 2, 6));
    this.getContentPane().add(lother, new GridBagConstraints(5, 4, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(6, 6, 0, 9), 1, 4));
    this.getContentPane().add(lqueen, new GridBagConstraints(5, 5, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(7, 14, 0, 0), 1, 6));
    this.getContentPane().add(lsglb, new GridBagConstraints(5, 6, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(7, 22, 0, 0), 2, 6));
    this.getContentPane().add(lsuit, new GridBagConstraints(5, 7, 1, 2, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 24, 0, 5), 1, 10));
    this.getContentPane().add(tdouble, new GridBagConstraints(6, 1, 1, 1, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(0, 14, 3, 7), 0, 0));
    this.getContentPane().add(tdoublerate, new GridBagConstraints(8, 1, 2, 1, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 8), 0, 0));
    this.getContentPane().add(tking, new GridBagConstraints(6, 2, 1, 1, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(2, 14, 4, 7), 0, 0));
    this.getContentPane().add(tkingrate, new GridBagConstraints(8, 2, 1, 1, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 2, 7), 0, 0));
    this.getContentPane().add(torcl, new GridBagConstraints(6, 3, 1, 1, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(0, 14, 3, 8), 0, 0));
    this.getContentPane().add(torclrate, new GridBagConstraints(8, 3, 1, 1, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 8), 0, 0));
    this.getContentPane().add(tothers, new GridBagConstraints(6, 4, 1, 1, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(4, 13, 0, 8), 0, 0));
    this.getContentPane().add(tothersrate, new GridBagConstraints(8, 4, 1, 1, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 7), 0, 0));
    this.getContentPane().add(tqueen, new GridBagConstraints(6, 5, 1, 1, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(6, 14, 0, 8), 0, 0));
    this.getContentPane().add(tqueenrate, new GridBagConstraints(8, 5, 1, 1, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(5, 0, 0, 7), 0, 0));
    this.getContentPane().add(tsglb, new GridBagConstraints(6, 6, 1, 1, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(7, 14, 0, 7), 0, 0));
    this.getContentPane().add(tsglbrate, new GridBagConstraints(8, 6, 1, 1, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(6, 0, 0, 7), 0, 0));
    this.getContentPane().add(tsuit, new GridBagConstraints(6, 7, 1, 1, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(4, 14, 8, 7), 89, 2));
    this.getContentPane().add(tsuitrate, new GridBagConstraints(8, 7, 1, 1, 1.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.HORIZONTAL, new Insets(4, 0, 8, 8), 0, 1));
    this.getContentPane().add(lrowfetched, new GridBagConstraints(0, 8, 2, 2, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(12, 16, 0, 0), 35, 14));
    this.getContentPane().add(lrowsdisplayed, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(8, 16, 0, 0), 10, 12));
    this.getContentPane().add(trowfetched, new GridBagConstraints(2, 8, 2, 2, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(12, 23, 0, 0), 75, 2));
    this.getContentPane().add(trowdisplayed, new GridBagConstraints(2, 10, 2, 1, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(6, 23, 0, 0), 0, 0));
    this.getContentPane().add(bsusres, new GridBagConstraints(0, 11, 3, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 46, 0, 0), 43, 7));
    this.getContentPane().add(bstart, new GridBagConstraints(6, 11, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 4, 0, 30), 93, 9));
    this.getContentPane().add(bexit, new GridBagConstraints(8, 11, 1, 1, 0.0, 0.0
            ,GridBagConstraints.SOUTH, GridBagConstraints.NONE, new Insets(0, 12, 0, 13), 86, 9));
    this.getContentPane().add(statusbar, new GridBagConstraints(0, 12, 12, 1, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(8, -1, -2, -3), 536, 16));
  }
}

