--
-- Define object type
CREATE TYPE queue_message_type AS OBJECT (
  no NUMBER,
  title VARCHAR2(30),
  text VARCHAR2(2000)
);
/
GRANT EXECUTE ON queue_message_type TO my_aq_user_role;
--
-- Single consumer queue
EXEC DBMS_AQADM.CREATE_QUEUE_TABLE (queue_table => 'queue_message_table', queue_payload_type => 'aqadm.queue_message_type');
EXEC DBMS_AQADM.CREATE_QUEUE (queue_name => 'message_queue', queue_table => 'queue_message_table');
EXEC DBMS_AQADM.START_QUEUE (queue_name => 'message_queue');
--
-- Multi consumer queue
EXEC DBMS_AQADM.CREATE_QUEUE_TABLE (queue_table => 'multi_message_table', queue_payload_type => 'SYS.AQ$_JMS_OBJECT_MESSAGE',	multiple_consumers => TRUE);
EXEC DBMS_AQADM.CREATE_QUEUE (queue_name => 'multi_queue', queue_table => 'multi_message_table');
EXEC DBMS_AQADM.START_QUEUE (queue_name => 'multi_queue');
--
EXIT;
