#!/bin/ksh
# Akadia AG, Arvenweg 4, CH-3604 Thun
# ----------------------------------------------------------------------
# File:       dbstart.sh
#
# Autor:      Martin Zahn / 10.02.2002
# 
# Purpose:    Startup Oracle Database(s) in $ORATAB
#
# Verified:   Oracle 9.0.1 on RedHat Linux 7.2
# ----------------------------------------------------------------------

ORATAB=/etc/oratab

trap 'exit' 1 2 3
    
# Set path if path not set (if called from /etc/rc)

case $PATH in
    "")  PATH=/bin:/usr/bin:/etc
         export PATH ;;
esac

# Loop for every entry in oratab file and and try to start
# that ORACLE

cat $ORATAB | while read LINE
do
  case $LINE in

  \#*)  # Comment in ORATAB
  ;;

  *)  #  Proceed only if third field is 'Y'

    if [ "`echo $LINE | awk -F: '{print $3}' -`" = "Y" ] ; then

      # Called programs use same database ID

      ORACLE_SID=`echo $LINE | awk -F: '{print $1}' -`
      if [ "$ORACLE_SID" = '*' ] ; then
        ORACLE_SID=""
      fi
      export ORACLE_SID

      # Called scripts use same home directory

      ORACLE_HOME=`echo $LINE | awk -F: '{print $2}' -`
      export ORACLE_HOME
      ORACLE_TERM=xterm; export ORACLE_TERM
      NLS_LANG=AMERICAN_AMERICA.WE8ISO8859P1; export NLS_LANG
      ORA_NLS33=$ORACLE_HOME/ocommon/nls/admin/data; export ORA_NLS33
      CLASSPATH=$ORACLE_HOME/jdbc/lib/classes111.zip; export CLASSPATH
      LD_LIBRARY_PATH=$ORACLE_HOME/lib; export LD_LIBRARY_PATH
      PATH=/bin:/sbin:/usr/bin:/usr/sbin:/usr/local/bin:$ORACLE_HOME/bin
      PATH=$PATH:/usr/local/sbin:/usr/bin/X11:/usr/X11R6/bin:/root/bin
      PATH=$PATH:/home/local/bin
      export PATH
      PFILE=${ORACLE_HOME}/dbs/init${ORACLE_SID}.ora

      if test  -f $ORACLE_HOME/dbs/sgadef${ORACLE_SID}.dbf  -o \
               -f $ORACLE_HOME/dbs/sgadef${ORACLE_SID}.ora
      then
        STATUS="-1"
      else
        STATUS=1
      fi

      case $STATUS in
         1)  if [ -f $PFILE ] ; then
                sqlplus /nolog <<EOF
connect / as sysdba
startup
EOF
                if test $? -eq 0 ; then
                  echo ""
                  echo "Database \"${ORACLE_SID}\" warm started."
                else
                  echo ""
                  echo "Database \"${ORACLE_SID}\" NOT started."
                fi
             else
                echo ""
                echo "Can't find init file for Database \"${ORACLE_SID}\"."
                echo "Database \"${ORACLE_SID}\" NOT started."
             fi
             ;;

        -1) echo ""
            echo "Database \"${ORACLE_SID}\" possibly left running when system went down (system crash?)."
            echo "Notify Database Administrator."

          sqlplus /nolog <<EOF
connect / as sysdba
shutdown immediate
EOF
            if test $? -eq 0 ; then
              if [ -f $PFILE ] ; then
                sqlplus /nolog <<EOF
connect / as sysdba
startup
EOF
                if test $? -eq 0 ; then
                  echo ""
                  echo "Database \"${ORACLE_SID}\" warm started."
                else
                  echo ""
                  echo "Database \"${ORACLE_SID}\" NOT started."
                fi
              else
                echo ""
                echo "Can't find init file for Database \"${ORACLE_SID}\"."
                echo "Database \"${ORACLE_SID}\" NOT started."
              fi
            else
              echo "Database \"${ORACLE_SID}\" NOT started."
            fi
            ;;
      esac
    fi  #  Proceed only if third field is 'Y'
    ;;
  esac
done
