REM Akadia AG, Fichtenweg 10, CH-3672 Oberdiessbach
REM --------------------------------------------------------------------------
REM File:        initQUO1.ora
REM
REM Autor:       Martin Zahn Akadia AG
REM
REM Purpose:     Create database QUO1
REM
REM Location:    $ORACLE_HOME/dbs
REM
REM Certified:   Oracle 10.2.0.3 on Sun Solaris 10
REM
REM Notes:       On Production Systems you should not set "AUTOEXTEND ON",
REM              this may fill up your file system until 100%.
REM --------------------------------------------------------------------------

SPOOL $HOME/config/10.2.0/init$ORACLE_SID.log;
CONNECT / AS SYSDBA;

REM Startup database
REM ----------------

REM STARTUP NOMOUNT pfile=$ORACLE_HOME/dbs/init$ORACLE_SID.ora
STARTUP NOMOUNT

REM Create database
REM ---------------

CREATE DATABASE QUO1
        CONTROLFILE     REUSE
        MAXDATAFILES    256
        MAXINSTANCES    4
        MAXLOGFILES     62
        MAXLOGMEMBERS   5
        MAXLOGHISTORY   1600
        CHARACTER SET   "WE8ISO8859P1"
        NATIONAL CHARACTER SET  "AL16UTF16"
        DATAFILE  '/u01/db/QUO1/sys/QUO1_sys1.dbf' SIZE 800M REUSE
	SYSAUX DATAFILE  '/u01/db/QUO1/sys/QUO1_sysaux1.dbf' SIZE 800M REUSE
          AUTOEXTEND ON NEXT 10240K MAXSIZE UNLIMITED EXTENT MANAGEMENT LOCAL
        UNDO TABLESPACE undo DATAFILE '/u01/db/QUO1/rbs/QUO1_undo1.dbf'
          SIZE 500M REUSE AUTOEXTEND ON NEXT 5120K MAXSIZE UNLIMITED
        DEFAULT TEMPORARY TABLESPACE temp
          TEMPFILE '/u01/db/QUO1/tmp/QUO1_temp1.dbf' SIZE 500M REUSE
          AUTOEXTEND ON NEXT 5120K MAXSIZE UNLIMITED EXTENT MANAGEMENT LOCAL
LOGFILE GROUP 1 ('/u01/db/QUO1/rdo/QUO1_log1A.rdo') SIZE 20M REUSE,
        GROUP 2 ('/u01/db/QUO1/rdo/QUO1_log2A.rdo') SIZE 20M REUSE,
        GROUP 3 ('/u01/db/QUO1/rdo/QUO1_log3A.rdo') SIZE 20M REUSE,
        GROUP 4 ('/u01/db/QUO1/rdo/QUO1_log4A.rdo') SIZE 20M REUSE,
        GROUP 5 ('/u01/db/QUO1/rdo/QUO1_log5A.rdo') SIZE 20M REUSE,
        GROUP 6 ('/u01/db/QUO1/rdo/QUO1_log6A.rdo') SIZE 20M REUSE;

REM Create a tablespace for database tools.
REM ---------------------------------------

CREATE TABLESPACE tools
    LOGGING
    DATAFILE '/u01/db/QUO1/tab/QUO1_tools01.dbf' SIZE 100M REUSE
    AUTOEXTEND ON NEXT 640K
    EXTENT MANAGEMENT LOCAL SEGMENT SPACE MANAGEMENT AUTO
    PERMANENT
    ONLINE;

REM Create a tablespace for Oracle Text data dictionary tables.
REM -----------------------------------------------------------

CREATE TABLESPACE drsys
    LOGGING
    DATAFILE '/u01/db/QUO1/tab/QUO1_drsys1.dbf' SIZE 200M REUSE
    AUTOEXTEND ON NEXT 640K
    EXTENT MANAGEMENT LOCAL SEGMENT SPACE MANAGEMENT AUTO
    PERMANENT
    ONLINE;

REM Create a tablespace for Oracle XML DB repository.
REM -------------------------------------------------

CREATE TABLESPACE xdb
    LOGGING
    DATAFILE '/u01/db/QUO1/tab/QUO1_xdb1.dbf' SIZE 200M REUSE
    AUTOEXTEND ON NEXT 640K
    EXTENT MANAGEMENT LOCAL SEGMENT SPACE MANAGEMENT AUTO
    PERMANENT
    ONLINE;

REM Create a tablespace for miscellaneous database user activity.
REM -------------------------------------------------------------

CREATE TABLESPACE users
    LOGGING   
    DATAFILE '/u01/db/QUO1/usr/QUO1_users01.dbf' SIZE 2000M REUSE
    AUTOEXTEND ON NEXT 10M MAXSIZE UNLIMITED
    EXTENT MANAGEMENT LOCAL SEGMENT SPACE MANAGEMENT AUTO
    PERMANENT
    ONLINE;

REM Set security for the administrative users
REM -----------------------------------------

ALTER USER sys
TEMPORARY TABLESPACE temp;
ALTER USER sys IDENTIFIED BY manager;

ALTER USER system
TEMPORARY TABLESPACE temp;
ALTER USER system IDENTIFIED BY manager;

REM Load the system scripts
REM -----------------------

DISCONNECT;
CONNECT / AS SYSDBA;
SET ECHO OFF;
SET TERMOUT ON;

REM Creates data dictionary views. This is the very first
REM Script which must be executed during Database Building
@$ORACLE_HOME/rdbms/admin/catalog.sql

REM Parallel-Server specific views for performance queries
@$ORACLE_HOME/rdbms/admin/catparr.sql

REM Scripts for the PL/SQL procedural option
@$ORACLE_HOME/rdbms/admin/catproc.sql

REM Create additional Scripts
REM -------------------------

REM Run all sql scripts for replication option
@$ORACLE_HOME/rdbms/admin/catrep.sql

REM Install Oracle7 Exp/Imp views
@$ORACLE_HOME/rdbms/admin/catexp7.sql

REM Locking view for OEM
@$ORACLE_HOME/rdbms/admin/catblock.sql

REM Create Oracle Cryptographic ToolKit   
@$ORACLE_HOME/rdbms/admin/catoctk.sql

REM Create user OWM_SYS for storing metadata
@$ORACLE_HOME/rdbms/admin/owminst.plb

REM Install Database pipes
@$ORACLE_HOME/rdbms/admin/dbmspipe.sql

REM Install Shared Pool management utilities
@$ORACLE_HOME/rdbms/admin/dbmspool.sql

REM Install Analyse tables
@$ORACLE_HOME/rdbms/admin/dbmsiotc.sql

REM Collect I/O per table (actually object) statistics
@$ORACLE_HOME/rdbms/admin/catio.sql

REM Install PLAN_TABLE in SYS account
@$ORACLE_HOME/rdbms/admin/utlxplan.sql

REM Install CHAINED_ROWS in SYS account
@$ORACLE_HOME/rdbms/admin/utlchain.sql

REM Install EXCEPTIONS in SYS account
@$ORACLE_HOME/rdbms/admin/utlexcpt.sql

REM Install PLUSTRACE in SYS account
@$ORACLE_HOME/sqlplus/admin/plustrce.sql

REM Install TKPROFER in SYS account
@$ORACLE_HOME/rdbms/admin/utltkprf.sql

REM Allow analyze of partitioned tables
@$ORACLE_HOME/rdbms/admin/utlvalid.sql

REM Print out the lock wait-for graph in a tree structured fashion
@$ORACLE_HOME/rdbms/admin/utllockt.sql

REM PL/SQL Package of utility routines for raw datatypes
@$ORACLE_HOME/rdbms/admin/utlraw.sql
@$ORACLE_HOME/rdbms/admin/prvtrawb.plb

REM Contains the PL/SQL interface to the cryptographic toolkit
@$ORACLE_HOME/rdbms/admin/dbmsoctk.sql
@$ORACLE_HOME/rdbms/admin/prvtoctk.plb

REM This package provides a built-in random number generator. It is
REM faster than generators written in PL/SQL because it calls Oracle's
REM internal random number generator.
@$ORACLE_HOME/rdbms/admin/dbmsrand.sql

REM DBMS package specification for Oracle8 Large Object
REM This package provides routines for operations on BLOB
REM and CLOB datatypes.
@$ORACLE_HOME/rdbms/admin/dbmslob.sql

REM Recompile all INVALID objects   
@$ORACLE_HOME/rdbms/admin/utlrp.sql

REM Password Verify Function (Uncomment if you want to use it)
REM ----------------------------------------------------------
REM @$ORACLE_HOME/rdbms/admin/utlpwdmg.sql

REM Create roles and users
REM ----------------------
REM GRANT EXECUTE ON dbms_pipe, dbms_alert must be granted
REM to the real users, not through a role !

DISCONNECT;
CONNECT system/manager;

CREATE USER scott IDENTIFIED BY tiger
    DEFAULT TABLESPACE users
    TEMPORARY TABLESPACE temp
    QUOTA 0 ON system
    PROFILE default;
    GRANT CONNECT,RESOURCE TO scott;
    GRANT ALL PRIVILEGES TO scott;

ALTER USER dbsnmp
TEMPORARY TABLESPACE temp;

DISCONNECT;
CONNECT / as SYSDBA;

GRANT EXECUTE ON dbms_pipe TO PUBLIC;
GRANT EXECUTE ON dbms_alert TO PUBLIC;
GRANT EXECUTE ON dbms_obfuscation_toolkit TO PUBLIC;

REM Setup PLAN_TABLE for TKPROF, SQL-Tuning
REM ---------------------------------------

GRANT DELETE,INSERT,UPDATE,SELECT ON sys.plan_table TO PUBLIC;
CREATE PUBLIC SYNONYM plan_table FOR sys.plan_table;
GRANT SELECT ON V_$PARAMETER TO PUBLIC;

REM Setup AUTO TRACE for SQL*PLUS
REM -----------------------------

@$ORACLE_HOME/sqlplus/admin/plustrce.sql
GRANT plustrace to scott;

DISCONNECT;
CONNECT system/manager;

REM SQL*PLUS product user profile
REM -----------------------------

@$ORACLE_HOME/sqlplus/admin/pupbld.sql

REM Create Help Tables for SQL*Plus
REM -------------------------------

@$ORACLE_HOME/sqlplus/admin/help/hlpbld.sql helpus.sql;

EXIT;
