#!/bin/ksh
# Akadia AG, Zieglerstrasse 34, CH-3007 Bern 
# ----------------------------------------------------------------------
# File:       dbshut.sh
#
# Autor:      Martin Zahn / 11.08.99 (Tag der Sonnenfinsternis)
# 
# Purpose:    Startup Oracle Database(s) in $ORATAB
# ----------------------------------------------------------------------

ORATAB=/var/opt/oracle/oratab

trap 'exit' 1 2 3
    
# Set path if path not set

case $PATH in
    "") PATH=/bin:/usr/bin:/etc
  export PATH ;;
esac

# Loop for every entry in oratab file and and try to start
# that ORACLE

cat $ORATAB | while read LINE
do
  case $LINE in

  \#*)  # Comment in ORATAB
  ;;

  *)  #  Proceed only if third field is 'Y'

    if [ "`echo $LINE | awk -F: '{print $3}' -`" = "Y" ] ; then

      # Called programs use same database ID

      ORACLE_SID=`echo $LINE | awk -F: '{print $1}' -`
      if [ "$ORACLE_SID" = '*' ] ; then
        ORACLE_SID=""
      fi
      export ORACLE_SID

      # Called scripts use same home directory

      ORACLE_HOME=`echo $LINE | awk -F: '{print $2}' -`
      export ORACLE_HOME
      PATH=$ORACLE_HOME/bin:/bin:/usr/bin:/etc ; export PATH
      PFILE=${ORACLE_HOME}/dbs/init${ORACLE_SID}.ora
      ORA_NLS32=$ORACLE_HOME/ocommon/nls/admin/data; export ORA_NLS32
      ORA_NLS33=$ORACLE_HOME/ocommon/nls/admin/data; export ORA_NLS33
      LD_LIBRARY_PATH=$ORACLE_HOME/lib:/lib:/usr/lib:/usr/openwin/lib
      LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/usr/dt/lib:/usr/ucblib:/usr/local/lib
      export LD_LIBRARY_PATH


      if test  -f $ORACLE_HOME/dbs/sgadef${ORACLE_SID}.dbf  -o \
               -f $ORACLE_HOME/dbs/sgadef${ORACLE_SID}.ora
      then
        STATUS="-1"
      else
        STATUS=1
      fi

      case $STATUS in
        1)  if [ -f $PFILE ] ; then
              svrmgrl <<EOF
connect internal
startup
EOF
              if test $? -eq 0 ; then
                echo ""
                echo "Database \"${ORACLE_SID}\" warm started."
              else
                echo ""
                echo "Database \"${ORACLE_SID}\" NOT started."
              fi
            else
              echo ""
              echo "Can't find init file for Database \"${ORACLE_SID}\"."
              echo "Database \"${ORACLE_SID}\" NOT started."
            fi
                    ;;

        -1) echo ""
            echo "Database \"${ORACLE_SID}\" possibly left running when system went down (system crash?)."
            echo "Notify Database Administrator."

            svrmgrl <<EOF
connect internal
shutdown immediate
EOF
            if test $? -eq 0 ; then
              if [ -f $PFILE ] ; then
                svrmgrl <<EOF
connect internal
startup
EOF
                if test $? -eq 0 ; then
                  echo ""
                  echo "Database \"${ORACLE_SID}\" warm started."
                else
                  echo ""
                  echo "Database \"${ORACLE_SID}\" NOT started."
                fi
              else
                echo ""
                echo "Can't find init file for Database \"${ORACLE_SID}\"."
                echo "Database \"${ORACLE_SID}\" NOT started."
              fi
            else
              echo "Database \"${ORACLE_SID}\" NOT started."
            fi
            ;;
      esac
    fi  #  Proceed only if third field is 'Y'
    ;;
  esac
done
