#!/bin/ksh
###############################################################################
#
# Install JServer and Intermedia
#
# Must be run as a UNIX user belongig to the dba group
#
###############################################################################

sqlplus << EOF
internal
spool JServer.log

### Setup a database for running Java and the ORB
### ---------------------------------------------
@$ORACLE_HOME/javavm/install/initjvm.sql

### Initializes Java library needed by PL/SQL
### -----------------------------------------
@$ORACLE_HOME/rdbms/admin/initplsj.sql

### Script used to load AQ/JMS jar files into the database
### ------------------------------------------------------
@$ORACLE_HOME/rdbms/admin/initaqjms.sql

### Load Java RepAPI server classes and publish 'repapi' obj
### --------------------------------------------------------
@$ORACLE_HOME/rdbms/admin/initrepapi.sql

disconnect
spool off
exit
EOF

### Oracle81x interMedia Installation of ORDSYS and ORDPLUGINS objects
### ------------------------------------------------------------------
sqlplus << EOF
internal
spool ordinst.log
@$ORACLE_HOME/ord/admin/ordinst.sql
spool off
exit
EOF

sqlplus << EOF
internal
SPOOL iminst.log
@$ORACLE_HOME/ord/im/admin/iminst.sql
spool off
exit
EOF

sqlplus << EOF
internal
spool spoolctx.log;
@$ORACLE_HOME/ctx/admin/dr0csys ctxsys DRSYS DRSYS
connect ctxsys/ctxsys
@$ORACLE_HOME/ctx/admin/dr0inst /opt/oracle/product/8.1.6/ctx/lib/libctxx8.so
@$ORACLE_HOME/ctx/admin/defaults/drdefus.sql
spool off
exit
EOF
