#!/bin/ksh
# Akadia AG, Arvenweg 4, CH-3604 Thun
# ----------------------------------------------------------------------
# File:       dbshut8.sh
#
# Autor:      Martin Zahn / 22.02.2002
# 
# Purpose:    Shutdown Oracle Database(s) in $ORATAB
# ----------------------------------------------------------------------

ORATAB=/var/opt/oracle/oratab8

trap 'exit' 1 2 3
case $ORACLE_TRACE in
    T)  set -x ;;
esac
    
# Set path if path not set

case $PATH in
    "") PATH=/bin:/usr/bin:/etc
  export PATH ;;
esac

# Loop for every entry in oratab file and and try to shutdown
# that ORACLE

cat $ORATAB | while read LINE
do
    case $LINE in

  \#*)  # Comment in ORATAB
    ;;

  *)  # Proceed only if third field is 'Y'

    if [ "`echo $LINE | awk -F: '{print $3}' -`" = "Y" ] ; then

      # Called programs use same database ID

      ORACLE_SID=`echo $LINE | awk -F: '{print $1}' -`
      if [ "$ORACLE_SID" = '*' ] ; then
        ORACLE_SID=""
      fi
      export ORACLE_SID
    
      # Called scripts use same home directory

      ORACLE_HOME=`echo $LINE | awk -F: '{print $2}' -`
      export ORACLE_HOME
      LD_LIBRARY_PATH=$ORACLE_HOME/lib:/lib:/usr/lib:/usr/openwin/lib
      LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/usr/dt/lib:/usr/ucblib:/usr/local/lib
      export LD_LIBRARY_PATH


      PATH=$ORACLE_HOME/bin:/bin:/usr/bin:/etc ; export PATH
      PFILE=${ORACLE_HOME}/dbs/init${ORACLE_SID}.ora

      svrmgrl <<EOF
connect internal
shutdown immediate
EOF
      if test $? -eq 0 ; then
        echo "Database \"${ORACLE_SID}\" shut down."
      else
        echo "Database \"${ORACLE_SID}\" not shut down."
      fi
    fi
    ;;
  esac
done
